/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.ClassLines;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.LegacyClassCoverage;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.FCollection;
import org.pitest.testapi.Description;
import org.pitest.util.Log;

public class CoverageData
implements CoverageDatabase {
    private static final Logger LOG = Log.getLogger();
    private final Map<BlockLocation, Set<TestInfo>> blockCoverage = new LinkedHashMap<BlockLocation, Set<TestInfo>>();
    private final LegacyClassCoverage legacyClassCoverage;
    private final CodeSource code;
    private final List<Description> failingTestDescriptions = new ArrayList<Description>();

    public CoverageData(CodeSource code, LineMap lm) {
        this.code = code;
        this.legacyClassCoverage = new LegacyClassCoverage(code, lm);
    }

    public void calculateClassCoverage(CoverageResult cr) {
        this.checkForFailedTest(cr);
        TestInfo ti = this.createTestInfo(cr.getTestUnitDescription(), cr.getExecutionTime(), cr.getNumberOfCoveredBlocks());
        this.legacyClassCoverage.addTestToClasses(ti, cr.getCoverage());
        for (BlockLocation each : cr.getCoverage()) {
            this.addTestsToBlockMap(ti, each);
        }
    }

    public void loadBlockDataOnly(Collection<BlockLocation> coverageData) {
        this.legacyClassCoverage.loadBlockDataOnly(coverageData);
    }

    @Override
    public Collection<TestInfo> getTestsForBlockLocation(BlockLocation location) {
        return this.blockCoverage.getOrDefault(location, Collections.emptySet());
    }

    public boolean allTestsGreen() {
        return this.failingTestDescriptions.isEmpty();
    }

    public int getCountFailedTests() {
        return this.failingTestDescriptions.size();
    }

    public List<Description> getFailingTestDescriptions() {
        return this.failingTestDescriptions;
    }

    @Override
    public ClassLines getCodeLinesForClass(ClassName clazz) {
        return this.legacyClassCoverage.getCodeLinesForClass(clazz);
    }

    @Override
    public Set<ClassLine> getCoveredLines(ClassName clazz) {
        return this.legacyClassCoverage.getCoveredLines(clazz);
    }

    @Override
    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        return this.legacyClassCoverage.getTestsForClass(clazz);
    }

    private void addTestsToBlockMap(TestInfo ti, BlockLocation each) {
        Set<TestInfo> tests = this.blockCoverage.get(each);
        if (tests == null) {
            tests = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
            this.blockCoverage.put(each, tests);
        }
        tests.add(ti);
    }

    @Override
    public BigInteger getCoverageIdForClass(ClassName clazz) {
        Collection<TestInfo> coverage = this.getTestsForClass(clazz);
        if (coverage.isEmpty()) {
            return BigInteger.ZERO;
        }
        return this.generateCoverageNumber(coverage);
    }

    public List<BlockCoverage> createCoverage() {
        return FCollection.map(this.blockCoverage.entrySet(), CoverageData.toBlockCoverage());
    }

    private static Function<Map.Entry<BlockLocation, Set<TestInfo>>, BlockCoverage> toBlockCoverage() {
        return a -> new BlockCoverage((BlockLocation)a.getKey(), (Collection)FCollection.map((Iterable)((Iterable)a.getValue()), (Function)TestInfo.toName()));
    }

    @Override
    public Collection<ClassLines> getClassesForFile(String sourceFile, String packageName) {
        return this.legacyClassCoverage.getClassesForFile(sourceFile, packageName);
    }

    private BigInteger generateCoverageNumber(Collection<TestInfo> coverage) {
        BigInteger coverageNumber = BigInteger.ZERO;
        Set<ClassName> testClasses = coverage.stream().map(TestInfo.toDefiningClassName()).collect(Collectors.toSet());
        for (ClassInfo each : this.code.getClassInfo(testClasses)) {
            coverageNumber = coverageNumber.add(each.getDeepHash());
        }
        return coverageNumber;
    }

    private void checkForFailedTest(CoverageResult cr) {
        if (!cr.isGreenTest()) {
            this.recordTestFailure(cr.getTestUnitDescription());
            LOG.severe(cr.getTestUnitDescription() + " did not pass without mutation.");
        }
    }

    private TestInfo createTestInfo(Description description, int executionTime, int linesCovered) {
        if (description.getFirstTestClass() == null) {
            System.out.println(description);
        }
        Optional<ClassName> testee = this.code.findTestee(description.getFirstTestClass());
        return new TestInfo(description.getFirstTestClass(), description.getQualifiedName(), executionTime, testee, linesCovered);
    }

    private void recordTestFailure(Description testDescription) {
        this.failingTestDescriptions.add(testDescription);
    }
}

