/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.mutationtest.verify.BuildVerifier;

class SpringVerifier
implements BuildVerifier {
    private final CodeSource code;

    SpringVerifier(CodeSource code) {
        this.code = code;
    }

    @Override
    public List<String> verify() {
        if (this.springIsOnClassPath() && !this.springPluginIsPresent()) {
            return Arrays.asList("Project uses Spring, but the Arcmutate Spring plugin is not present (https://docs.arcmutate.com/docs/spring.html)");
        }
        return Collections.emptyList();
    }

    private boolean springPluginIsPresent() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"com.groupcdg.arcmutate.spring.PluginMarker")).isPresent();
    }

    private boolean springIsOnClassPath() {
        return this.code.fetchClassBytes(ClassName.fromString((String)"org.springframework.core.SpringVersion")).isPresent();
    }
}

