/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.util.concurrent.TimeUnit;

public class TimeSpan {
    private long start;
    private long end;

    public TimeSpan(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long duration() {
        return TimeUnit.NANOSECONDS.toMillis(this.end - this.start);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public String toString() {
        long millis = this.duration();
        int seconds = (int)(TimeUnit.MILLISECONDS.toSeconds(millis) % 60L);
        int minutes = (int)(TimeUnit.MILLISECONDS.toMinutes(millis) % 60L);
        int hours = (int)TimeUnit.MILLISECONDS.toHours(millis);
        if (hours != 0) {
            return "" + hours + " hours, " + minutes + " minutes and " + seconds + " seconds";
        }
        if (minutes != 0) {
            return "" + minutes + " minutes and " + seconds + " seconds";
        }
        if (seconds != 0) {
            return "" + seconds + " seconds";
        }
        return "< 1 second";
    }
}

