/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classpath.ClassFilter;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.PathFilter;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.Streams;
import org.pitest.functional.predicate.And;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.config.DatedDirectoryReportDirCreationStrategy;
import org.pitest.mutationtest.config.DefaultCodePathPredicate;
import org.pitest.mutationtest.config.DefaultDependencyPathPredicate;
import org.pitest.mutationtest.config.DirectoryResultOutputStrategy;
import org.pitest.mutationtest.config.ExecutionMode;
import org.pitest.mutationtest.config.PathNamePredicate;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.mutationtest.config.UndatedReportDirCreationStrategy;
import org.pitest.mutationtest.incremental.FileWriterFactory;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.execute.Pitest;
import org.pitest.util.Glob;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;
import org.pitest.util.Verbosity;

public class ReportOptions {
    public static final Collection<String> LOGGING_CLASSES = Arrays.asList("java.util.logging", "org.apache.log4j", "org.apache.logging.log4j", "org.slf4j", "org.apache.commons.logging", "org.jboss.logging");
    private Collection<String> targetClasses;
    private Collection<String> excludedMethods = Collections.emptyList();
    private Collection<String> excludedClasses = Collections.emptyList();
    private Collection<Predicate<String>> excludedTestClasses = Collections.emptyList();
    private Collection<String> codePaths;
    private String reportDir;
    private File historyInputLocation;
    private File historyOutputLocation;
    private Collection<Path> sourceDirs;
    private Collection<String> classPathElements;
    private Collection<String> mutators;
    private Collection<String> features;
    private String argLine;
    private final List<String> jvmArgs = new ArrayList<String>();
    private int numberOfThreads = 0;
    private float timeoutFactor = 1.25f;
    private long timeoutConstant = 4000L;
    private Collection<Predicate<String>> targetTests;
    private Collection<String> loggingClasses = new ArrayList<String>();
    private Verbosity verbosity = Verbosity.DEFAULT;
    private boolean failWhenNoMutations = false;
    private boolean skipFailingTests = false;
    private final Collection<String> outputs = new LinkedHashSet<String>();
    private TestGroupConfig groupConfig;
    private boolean fullMutationMatrix = false;
    private int mutationUnitSize;
    private boolean shouldCreateTimestampedReports = true;
    private boolean detectInlinedCode = false;
    private boolean exportLineCoverage = false;
    private int mutationThreshold;
    private int coverageThreshold;
    private int testStrengthThreshold;
    private String mutationEngine = "gregor";
    private String javaExecutable;
    private boolean includeLaunchClasspath = true;
    private boolean reportCoverage = true;
    private Properties properties;
    private int maxSurvivors;
    private Collection<String> excludedRunners = new ArrayList<String>();
    private Collection<String> includedTestMethods = new ArrayList<String>();
    private String testPlugin = "";
    private Path projectBase;
    private Charset inputEncoding;
    private Charset outputEncoding;
    private boolean arcmutateMissing = true;
    private ExecutionMode mode = ExecutionMode.NORMAL;
    private Map<String, String> environmentVariables = new HashMap<String, String>();

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public Collection<Path> getSourcePaths() {
        return this.sourceDirs;
    }

    @Deprecated
    public Collection<File> getSourceDirs() {
        return this.sourceDirs.stream().map(Path::toFile).collect(Collectors.toList());
    }

    public Collection<String> getClassPathElements() {
        return this.classPathElements;
    }

    public void setClassPathElements(Collection<String> classPathElements) {
        this.classPathElements = classPathElements;
    }

    public void setSourceDirs(Collection<Path> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Collection<String> getMutators() {
        return this.mutators;
    }

    public void setMutators(Collection<String> mutators) {
        this.mutators = mutators;
    }

    public Collection<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        this.features = features;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void addChildJVMArgs(List<String> args) {
        this.jvmArgs.addAll(args);
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public ClassPath getClassPath() {
        if (this.classPathElements != null) {
            return this.createClassPathFromElements();
        }
        return new ClassPath();
    }

    private ClassPath createClassPathFromElements() {
        return new ClassPath((Collection)Streams.asStream(this.classPathElements).map(File::new).collect(Collectors.toList()));
    }

    public Collection<String> getTargetClasses() {
        return this.targetClasses;
    }

    public Predicate<String> getTargetClassesFilter() {
        And filter = Prelude.and((Predicate[])new Predicate[]{Prelude.or((Iterable)Glob.toGlobPredicates(this.targetClasses)), Prelude.not(ReportOptions.isBlackListed(Glob.toGlobPredicates(this.excludedClasses)))});
        this.checkNotTryingToMutateSelf((Predicate<String>)filter);
        return filter;
    }

    private void checkNotTryingToMutateSelf(Predicate<String> filter) {
        if (filter.test(Pitest.class.getName())) {
            throw new PitHelpError(Help.BAD_FILTER, new Object[0]);
        }
    }

    public void setTargetClasses(Collection<String> targetClasses) {
        this.targetClasses = targetClasses;
    }

    public void setTargetTests(Collection<Predicate<String>> targetTestsPredicates) {
        this.targetTests = targetTestsPredicates;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public long getTimeoutConstant() {
        return this.timeoutConstant;
    }

    public void setTimeoutConstant(long timeoutConstant) {
        this.timeoutConstant = timeoutConstant;
    }

    public void setTimeoutFactor(float timeoutFactor) {
        this.timeoutFactor = timeoutFactor;
    }

    public Collection<Predicate<String>> getTargetTests() {
        return this.targetTests;
    }

    public Predicate<String> getTargetTestsFilter() {
        if (this.targetTests == null || this.targetTests.isEmpty()) {
            return Prelude.and((Predicate[])new Predicate[]{Prelude.or((Iterable)Glob.toGlobPredicates(this.targetClasses)), Prelude.not(ReportOptions.isBlackListed(this.excludedTestClasses))});
        }
        return Prelude.and((Predicate[])new Predicate[]{Prelude.or(this.targetTests), Prelude.not(ReportOptions.isBlackListed(this.excludedTestClasses))});
    }

    private static Predicate<String> isBlackListed(Collection<Predicate<String>> excludedClasses) {
        return Prelude.or(excludedClasses);
    }

    public Collection<String> getLoggingClasses() {
        if (this.loggingClasses.isEmpty()) {
            return LOGGING_CLASSES;
        }
        return this.loggingClasses;
    }

    public void setLoggingClasses(Collection<String> loggingClasses) {
        this.loggingClasses = loggingClasses;
    }

    public Collection<String> getExcludedMethods() {
        return this.excludedMethods;
    }

    public void setExcludedMethods(Collection<String> excludedMethods) {
        this.excludedMethods = excludedMethods;
    }

    public void setVerbosity(Verbosity verbose) {
        this.verbosity = verbose;
    }

    public void setExcludedClasses(Collection<String> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setExcludedTestClasses(Collection<Predicate<String>> excludedClasses) {
        this.excludedTestClasses = excludedClasses;
    }

    public void addOutputFormats(Collection<String> formats) {
        this.outputs.addAll(formats);
    }

    public Collection<String> getOutputFormats() {
        return this.outputs;
    }

    public Collection<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Collection<Predicate<String>> getExcludedTestClasses() {
        return this.excludedTestClasses;
    }

    public boolean shouldFailWhenNoMutations() {
        return this.failWhenNoMutations;
    }

    public void setFailWhenNoMutations(boolean failWhenNoMutations) {
        this.failWhenNoMutations = failWhenNoMutations;
    }

    public boolean skipFailingTests() {
        return this.skipFailingTests;
    }

    public void setSkipFailingTests(boolean skipFailingTests) {
        this.skipFailingTests = skipFailingTests;
    }

    public ProjectClassPaths getMutationClassPaths() {
        return new ProjectClassPaths(this.getClassPath(), this.createClassesFilter(), this.createPathFilter());
    }

    public ClassFilter createClassesFilter() {
        return new ClassFilter(this.getTargetTestsFilter(), this.getTargetClassesFilter());
    }

    private PathFilter createPathFilter() {
        return new PathFilter(this.createCodePathFilter(), Prelude.not((Predicate)new DefaultDependencyPathPredicate()));
    }

    private Predicate<ClassPathRoot> createCodePathFilter() {
        if (this.codePaths != null && !this.codePaths.isEmpty()) {
            return new PathNamePredicate((Predicate<String>)Prelude.or((Iterable)Glob.toGlobPredicates(this.codePaths)));
        }
        return new DefaultCodePathPredicate();
    }

    public Collection<String> getCodePaths() {
        return this.codePaths;
    }

    public void setCodePaths(Collection<String> codePaths) {
        this.codePaths = codePaths;
    }

    public void setGroupConfig(TestGroupConfig groupConfig) {
        this.groupConfig = groupConfig;
    }

    public TestGroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public void setFullMutationMatrix(boolean fullMutationMatrix) {
        this.fullMutationMatrix = fullMutationMatrix;
    }

    public boolean isFullMutationMatrix() {
        return this.fullMutationMatrix;
    }

    public int getMutationUnitSize() {
        return this.mutationUnitSize;
    }

    public void setMutationUnitSize(int size) {
        this.mutationUnitSize = size;
    }

    public ResultOutputStrategy getReportDirectoryStrategy() {
        return new DirectoryResultOutputStrategy(this.getReportDir(), this.pickDirectoryStrategy());
    }

    public void setShouldCreateTimestampedReports(boolean shouldCreateTimestampedReports) {
        this.shouldCreateTimestampedReports = shouldCreateTimestampedReports;
    }

    private ReportDirCreationStrategy pickDirectoryStrategy() {
        if (this.shouldCreateTimestampedReports) {
            return new DatedDirectoryReportDirCreationStrategy();
        }
        return new UndatedReportDirCreationStrategy();
    }

    public boolean shouldCreateTimeStampedReports() {
        return this.shouldCreateTimestampedReports;
    }

    public boolean isDetectInlinedCode() {
        return this.detectInlinedCode;
    }

    public void setDetectInlinedCode(boolean b) {
        this.detectInlinedCode = b;
    }

    public Optional<WriterFactory> createHistoryWriter() {
        if (this.historyOutputLocation == null) {
            return Optional.empty();
        }
        return Optional.of(new FileWriterFactory(this.historyOutputLocation));
    }

    public Optional<Reader> createHistoryReader() {
        if (this.historyInputLocation == null) {
            return Optional.empty();
        }
        try {
            if (this.historyInputLocation.exists() && this.historyInputLocation.length() > 0L) {
                return Optional.of(new InputStreamReader(Files.newInputStream(this.historyInputLocation.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    public void setHistoryInputLocation(File historyInputLocation) {
        this.historyInputLocation = historyInputLocation;
    }

    public void setHistoryOutputLocation(File historyOutputLocation) {
        this.historyOutputLocation = historyOutputLocation;
    }

    public File getHistoryInputLocation() {
        return this.historyInputLocation;
    }

    public File getHistoryOutputLocation() {
        return this.historyOutputLocation;
    }

    public void setExportLineCoverage(boolean value) {
        this.exportLineCoverage = value;
    }

    public boolean shouldExportLineCoverage() {
        return this.exportLineCoverage;
    }

    public int getMutationThreshold() {
        return this.mutationThreshold;
    }

    public void setMutationThreshold(int value) {
        this.mutationThreshold = value;
    }

    public String getMutationEngine() {
        return this.mutationEngine;
    }

    public void setMutationEngine(String mutationEngine) {
        this.mutationEngine = mutationEngine;
    }

    public int getCoverageThreshold() {
        return this.coverageThreshold;
    }

    public void setCoverageThreshold(int coverageThreshold) {
        this.coverageThreshold = coverageThreshold;
    }

    public int getTestStrengthThreshold() {
        return this.testStrengthThreshold;
    }

    public void setTestStrengthThreshold(int testStrengthThreshold) {
        this.testStrengthThreshold = testStrengthThreshold;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public void setIncludeLaunchClasspath(boolean b) {
        this.includeLaunchClasspath = b;
    }

    public boolean isIncludeLaunchClasspath() {
        return this.includeLaunchClasspath;
    }

    public Properties getFreeFormProperties() {
        return this.properties;
    }

    public void setFreeFormProperties(Properties props) {
        this.properties = props;
    }

    public int getMaximumAllowedSurvivors() {
        return this.maxSurvivors;
    }

    public void setMaximumAllowedSurvivors(int maxSurvivors) {
        this.maxSurvivors = maxSurvivors;
    }

    public Collection<String> getExcludedRunners() {
        return this.excludedRunners;
    }

    public Collection<String> getIncludedTestMethods() {
        return this.includedTestMethods;
    }

    public void setExcludedRunners(Collection<String> excludedRunners) {
        this.excludedRunners = excludedRunners;
    }

    public void setIncludedTestMethods(Collection<String> includedTestMethods) {
        this.includedTestMethods = includedTestMethods;
    }

    public TestPluginArguments createMinionSettings() {
        return new TestPluginArguments(this.getGroupConfig(), this.getExcludedRunners(), this.getIncludedTestMethods(), this.skipFailingTests());
    }

    public Path getProjectBase() {
        return this.projectBase;
    }

    public void setProjectBase(Path projectBase) {
        this.projectBase = projectBase;
    }

    public Charset getInputEncoding() {
        return this.inputEncoding;
    }

    public void setInputEncoding(Charset inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(Charset outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public boolean shouldReportCoverage() {
        return this.reportCoverage;
    }

    public void setReportCoverage(boolean reportCoverage) {
        this.reportCoverage = reportCoverage;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean isArcmutateMissing() {
        return this.arcmutateMissing;
    }

    public void setArcmutateMissing(boolean arcmutateMissing) {
        this.arcmutateMissing = arcmutateMissing;
    }

    public ExecutionMode mode() {
        return this.mode;
    }

    public void setExecutionMode(ExecutionMode mode) {
        this.mode = mode;
    }

    public String toString() {
        return new StringJoiner(", ", ReportOptions.class.getSimpleName() + "[", "]").add("mode=" + this.mode).add("targetClasses=" + this.targetClasses).add("excludedMethods=" + this.excludedMethods).add("excludedClasses=" + this.excludedClasses).add("excludedTestClasses=" + this.excludedTestClasses).add("codePaths=" + this.codePaths).add("reportDir='" + this.reportDir + "'").add("historyInputLocation=" + this.historyInputLocation).add("historyOutputLocation=" + this.historyOutputLocation).add("sourceDirs=" + this.sourceDirs).add("classPathElements=" + this.classPathElements).add("mutators=" + this.mutators).add("features=" + this.features).add("jvmArgs=" + this.jvmArgs).add("argLine=" + this.argLine).add("numberOfThreads=" + this.numberOfThreads).add("timeoutFactor=" + this.timeoutFactor).add("timeoutConstant=" + this.timeoutConstant).add("targetTests=" + this.targetTests).add("loggingClasses=" + this.loggingClasses).add("verbosity=" + this.verbosity).add("failWhenNoMutations=" + this.failWhenNoMutations).add("skipFailingTests=" + this.skipFailingTests).add("outputs=" + this.outputs).add("groupConfig=" + this.groupConfig).add("fullMutationMatrix=" + this.fullMutationMatrix).add("mutationUnitSize=" + this.mutationUnitSize).add("shouldCreateTimestampedReports=" + this.shouldCreateTimestampedReports).add("detectInlinedCode=" + this.detectInlinedCode).add("exportLineCoverage=" + this.exportLineCoverage).add("mutationThreshold=" + this.mutationThreshold).add("coverageThreshold=" + this.coverageThreshold).add("testStrengthThreshold=" + this.testStrengthThreshold).add("mutationEngine='" + this.mutationEngine + "'").add("javaExecutable='" + this.javaExecutable + "'").add("includeLaunchClasspath=" + this.includeLaunchClasspath).add("properties=" + this.properties).add("maxSurvivors=" + this.maxSurvivors).add("excludedRunners=" + this.excludedRunners).add("includedTestMethods=" + this.includedTestMethods).add("testPlugin='" + this.testPlugin + "'").add("projectBase=" + this.projectBase).add("inputEncoding=" + this.inputEncoding).add("outputEncoding=" + this.outputEncoding).add("reportCoverage=" + this.reportCoverage).add("arcmutateMissing=" + this.arcmutateMissing).toString();
    }
}

