/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.execute.CoverageMinion;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.Receive;
import org.pitest.coverage.execute.SendData;
import org.pitest.process.ProcessArgs;
import org.pitest.process.WrappingProcess;
import org.pitest.util.CommunicationThread;
import org.pitest.util.ExitCode;

public class CoverageProcess {
    private final WrappingProcess process;
    private final CommunicationThread crt;

    public CoverageProcess(ProcessArgs processArgs, CoverageOptions arguments, ServerSocket socket, List<String> testClasses, Consumer<CoverageResult> handler) {
        this.process = WrappingProcess.create(socket.getLocalPort(), processArgs, CoverageMinion.class);
        this.crt = new CommunicationThread(socket, new SendData(arguments, testClasses), new Receive(handler));
    }

    public void start() throws IOException, InterruptedException {
        this.crt.start();
        this.process.start();
    }

    public ExitCode waitToDie() {
        try {
            Optional<ExitCode> maybeExit = this.crt.waitToFinish(5);
            while (maybeExit.isEmpty() && this.process.isAlive()) {
                maybeExit = this.crt.waitToFinish(10);
            }
            maybeExit = this.crt.waitToFinish(10);
            ExitCode exitCode = maybeExit.orElse(ExitCode.MINION_DIED);
            return exitCode;
        }
        finally {
            this.process.destroy();
        }
    }
}

