/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.pitest.util.Log;
import org.pitest.util.Monitor;

public class StreamMonitor
extends Thread
implements Monitor {
    private static final Logger LOG = Log.getLogger();
    private final InputStream in;
    private final Consumer<String> inputHandler;

    public StreamMonitor(InputStream in, Consumer<String> inputHandler) {
        super("PIT Stream Monitor");
        this.in = in;
        this.inputHandler = inputHandler;
        this.setDaemon(true);
    }

    @Override
    public void requestStart() {
        this.start();
    }

    @Override
    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
        while (!this.isInterrupted()) {
            this.readFromStream(reader);
        }
    }

    private void readFromStream(BufferedReader reader) {
        try {
            String output;
            if (!reader.ready()) {
                Thread.sleep(100L);
                return;
            }
            while ((output = reader.readLine()) != null) {
                this.inputHandler.accept(output);
            }
        }
        catch (IOException e) {
            this.requestStop();
            LOG.fine("No longer able to read stream.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void requestStop() {
        this.interrupt();
    }
}

