/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.util.Collection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.MutableList;

public class ClassTree {
    private final ClassNode rawNode;
    private FunctionalList<MethodTree> lazyMethods;

    public ClassTree(ClassNode rawNode) {
        this.rawNode = rawNode;
    }

    public static ClassTree fromBytes(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, 8);
        return new ClassTree(classNode);
    }

    public FunctionalList<MethodTree> methods() {
        if (this.lazyMethods != null) {
            return this.lazyMethods;
        }
        this.lazyMethods = FCollection.map((Iterable)this.rawNode.methods, ClassTree.toTree(this.name()));
        return this.lazyMethods;
    }

    public FunctionalList<AnnotationNode> annotations() {
        MutableList annotaions = new MutableList();
        if (this.rawNode.invisibleAnnotations != null) {
            annotaions.addAll((Collection)this.rawNode.invisibleAnnotations);
        }
        if (this.rawNode.visibleAnnotations != null) {
            annotaions.addAll((Collection)this.rawNode.visibleAnnotations);
        }
        return annotaions;
    }

    private static F<MethodNode, MethodTree> toTree(final ClassName name) {
        return new F<MethodNode, MethodTree>(){

            public MethodTree apply(MethodNode a) {
                return new MethodTree(name, a);
            }
        };
    }

    public ClassName name() {
        return ClassName.fromString((String)this.rawNode.name);
    }

    public ClassNode rawNode() {
        return this.rawNode;
    }
}

