/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Collection;
import java.util.List;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.mutationtest.build.CompoundMutationInterceptor;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.FeatureSelector;
import org.pitest.plugin.FeatureSetting;

public class CompoundInterceptorFactory {
    private final FeatureSelector<MutationInterceptorFactory> features;

    public CompoundInterceptorFactory(List<FeatureSetting> features, Collection<MutationInterceptorFactory> filters) {
        this.features = new FeatureSelector(features, filters);
    }

    public MutationInterceptor createInterceptor(ReportOptions data, ClassByteArraySource source) {
        FunctionalList interceptors = FCollection.map((Iterable)this.features.getActiveFeatures(), CompoundInterceptorFactory.toInterceptor(this.features, data, source));
        return new CompoundMutationInterceptor((List<MutationInterceptor>)interceptors);
    }

    private static F<MutationInterceptorFactory, MutationInterceptor> toInterceptor(final FeatureSelector<MutationInterceptorFactory> features, final ReportOptions data, final ClassByteArraySource source) {
        return new F<MutationInterceptorFactory, MutationInterceptor>(){

            public MutationInterceptor apply(MutationInterceptorFactory a) {
                return a.createInterceptor(new InterceptorParameters(features.getSettingForFeature(a.provides().name()), data, source));
            }
        };
    }
}

