/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.CachingByteArraySource;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.filter.MutationFilter;
import org.pitest.util.Log;

public class MutationSource {
    private static final Logger LOG = Log.getLogger();
    private final MutationConfig mutationConfig;
    private final TestPrioritiser testPrioritiser;
    private final MutationFilter filter;
    private final ClassByteArraySource source;
    private final MutationInterceptor interceptor;

    public MutationSource(MutationConfig mutationConfig, MutationFilter filter, TestPrioritiser testPrioritiser, ClassByteArraySource source, MutationInterceptor interceptor) {
        this.mutationConfig = mutationConfig;
        this.testPrioritiser = testPrioritiser;
        this.filter = filter;
        this.source = new CachingByteArraySource(source, 200);
        this.interceptor = interceptor;
    }

    public Collection<MutationDetails> createMutations(ClassName clazz) {
        Mutater m = this.mutationConfig.createMutator(this.source);
        Collection<MutationDetails> availableMutations = this.filter.filter(m.findMutations(clazz));
        if (availableMutations.isEmpty()) {
            return availableMutations;
        }
        ClassTree tree = ClassTree.fromBytes((byte[])this.source.getBytes(clazz.asJavaName()).value());
        this.interceptor.begin(tree);
        Collection<MutationDetails> updatedMutations = this.interceptor.intercept(availableMutations, m);
        this.interceptor.end();
        this.assignTestsToMutations(updatedMutations);
        return updatedMutations;
    }

    private void assignTestsToMutations(Collection<MutationDetails> availableMutations) {
        for (MutationDetails mutation : availableMutations) {
            List<TestInfo> testDetails = this.testPrioritiser.assignTests(mutation);
            if (testDetails.isEmpty()) {
                LOG.fine("According to coverage no tests hit the mutation " + mutation);
            }
            mutation.addTestsInOrder(testDetails);
        }
    }
}

