/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.annotations;

import java.util.Arrays;
import java.util.List;
import org.pitest.functional.Option;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.intercept.annotations.ExcludedAnnotationInterceptor;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureSetting;

public class ExcludedAnnotationInterceptorFactory
implements MutationInterceptorFactory {
    private static final String ARGUMENT = "annotation";

    public String description() {
        return "Excluded annotations plugin";
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        return new ExcludedAnnotationInterceptor(this.determineAnnotations(params.settings()));
    }

    private List<String> determineAnnotations(Option<FeatureSetting> settings) {
        if (settings.hasNone() || ((FeatureSetting)settings.value()).getList(ARGUMENT).isEmpty()) {
            return Arrays.asList("Generated", "DoNotMutate", "CoverageIgnore");
        }
        return ((FeatureSetting)settings.value()).getList(ARGUMENT);
    }

    public Feature provides() {
        return Feature.named((String)"FANN").withOnByDefault(true).withDescription("Filters mutations in classes and methods with matching annotations of class or runtime retention");
    }
}

