/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Match;
import org.pitest.sequence.SequenceMatcher;

public abstract class InfiniteLoopFilter
implements MutationInterceptor {
    static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    abstract SequenceMatcher<AbstractInsnNode> infiniteLoopMatcher();

    abstract boolean couldCauseInfiniteLoop(MethodTree var1, MutationDetails var2);

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        Map buckets = FCollection.bucket(mutations, this.mutationToLocation());
        ArrayList<MutationDetails> willTimeout = new ArrayList<MutationDetails>();
        for (Map.Entry each : buckets.entrySet()) {
            willTimeout.addAll(this.findTimeoutMutants((Location)each.getKey(), (Collection)each.getValue(), m));
        }
        mutations.removeAll(willTimeout);
        return mutations;
    }

    private Collection<MutationDetails> findTimeoutMutants(Location location, Collection<MutationDetails> mutations, Mutater m) {
        MethodTree method = (MethodTree)this.currentClass.methods().findFirst(MethodMatchers.forLocation(location)).value();
        if (this.infiniteLoopMatcher().matches(method.instructions())) {
            return Collections.emptyList();
        }
        ArrayList<MutationDetails> timeouts = new ArrayList<MutationDetails>();
        for (MutationDetails each : mutations) {
            if (!this.couldCauseInfiniteLoop(method, each) || !this.isInfiniteLoop(each, m)) continue;
            timeouts.add(each);
        }
        return timeouts;
    }

    private boolean isInfiniteLoop(MutationDetails each, Mutater m) {
        ClassTree mutantClass = ClassTree.fromBytes(m.getMutation(each.getId()).getBytes());
        Option mutantMethod = mutantClass.methods().findFirst(MethodMatchers.forLocation(each.getId().getLocation()));
        return this.infiniteLoopMatcher().matches(((MethodTree)mutantMethod.value()).instructions());
    }

    private F<MutationDetails, Location> mutationToLocation() {
        return new F<MutationDetails, Location>(){

            public Location apply(MutationDetails a) {
                return a.getId().getLocation();
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

