/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.mutationtest.filter.CompoundMutationFilter;
import org.pitest.mutationtest.filter.MutationFilter;
import org.pitest.mutationtest.filter.MutationFilterFactory;

public class CompoundFilterFactory
implements MutationFilterFactory {
    private final List<MutationFilterFactory> children = new ArrayList<MutationFilterFactory>();

    public CompoundFilterFactory(Collection<? extends MutationFilterFactory> filters) {
        this.children.addAll(filters);
    }

    public String description() {
        return null;
    }

    @Override
    public MutationFilter createFilter(Properties props, CodeSource source, int maxMutationsPerClass) {
        FunctionalList filters = FCollection.map(this.children, CompoundFilterFactory.toFilter(props, source, maxMutationsPerClass));
        return new CompoundMutationFilter((List<MutationFilter>)filters);
    }

    private static F<MutationFilterFactory, MutationFilter> toFilter(final Properties props, final CodeSource source, final int maxMutationsPerClass) {
        return new F<MutationFilterFactory, MutationFilter>(){

            public MutationFilter apply(MutationFilterFactory a) {
                return a.createFilter(props, source, maxMutationsPerClass);
            }
        };
    }
}

