/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.io.PrintStream;
import org.pitest.mutationtest.statistics.StatusCount;
import org.pitest.util.PercentageCalculator;

public final class Score {
    private final String mutatorName;
    private final Iterable<StatusCount> counts;
    private final long totalMutations;
    private final long totalDetected;
    private final long totalWithCoverage;

    public Score(String name, Iterable<StatusCount> counts, long totalMutations, long totalDetected, long totalWithCoverage) {
        this.mutatorName = name;
        this.counts = counts;
        this.totalMutations = totalMutations;
        this.totalDetected = totalDetected;
        this.totalWithCoverage = totalWithCoverage;
    }

    public void report(PrintStream out) {
        out.println("> " + this.mutatorName);
        out.println(">> Generated " + this.totalMutations + " Killed " + this.totalDetected + " (" + this.getPercentageDetected() + "%)");
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (StatusCount each : this.counts) {
            sb.append(String.valueOf(each) + " ");
            if (++i % 4 != 0) continue;
            out.println("> " + String.valueOf(sb));
            sb = new StringBuilder();
        }
        out.println("> " + String.valueOf(sb));
    }

    public String getMutatorName() {
        return this.mutatorName;
    }

    public long getTotalMutations() {
        return this.totalMutations;
    }

    public long getTotalDetectedMutations() {
        return this.totalDetected;
    }

    public long getTotalWithCoverage() {
        return this.totalWithCoverage;
    }

    public int getPercentageDetected() {
        return PercentageCalculator.getPercentage(this.getTotalMutations(), this.getTotalDetectedMutations());
    }
}

