/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.javafeatures.LineMutatorPair;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.util.Log;

public class InlinedFinallyBlockFilter
implements MutationInterceptor {
    private static final Logger LOG = Log.getLogger();
    private static final boolean DEBUG = false;
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final Slot<List> HANDLERS = Slot.create(List.class);
    static final SequenceMatcher<AbstractInsnNode> IS_IN_HANDLER = QueryStart.any(AbstractInsnNode.class).then(InlinedFinallyBlockFilter.handlerLabel(HANDLERS)).zeroOrMore(QueryStart.match(InlinedFinallyBlockFilter.doesNotEndBlock())).then(InstructionMatchers.isInstruction(MUTATED_INSTRUCTION.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));
    private ClassTree currentClass;

    private static Match<AbstractInsnNode> doesNotEndBlock() {
        return InlinedFinallyBlockFilter.endsBlock().negate();
    }

    private static Match<AbstractInsnNode> endsBlock() {
        return OpcodeMatchers.RETURN.or(OpcodeMatchers.ARETURN).or(OpcodeMatchers.DRETURN).or(OpcodeMatchers.FRETURN).or(OpcodeMatchers.IRETURN).or(OpcodeMatchers.LRETURN).or(OpcodeMatchers.ATHROW);
    }

    private static Match<AbstractInsnNode> handlerLabel(Slot<List> handlers) {
        return (c, t) -> {
            if (t instanceof LabelNode) {
                LabelNode label = (LabelNode)t;
                List labels = (List)c.retrieve(handlers.read()).get();
                return Result.result(labels.contains(label), c);
            }
            return Result.result(false, c);
        };
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        ArrayList<MutationDetails> combined = new ArrayList<MutationDetails>(mutations.size());
        Map mutatorLineBuckets = FCollection.bucket(mutations, InlinedFinallyBlockFilter.toLineMutatorPair());
        for (Map.Entry each : mutatorLineBuckets.entrySet()) {
            if (((Collection)each.getValue()).size() > 1) {
                this.checkForInlinedCode(combined, (Collection)each.getValue());
                continue;
            }
            combined.addAll((Collection)each.getValue());
        }
        combined.sort(InlinedFinallyBlockFilter.compareLineNumbers());
        return combined;
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    private static Comparator<MutationDetails> compareLineNumbers() {
        return Comparator.comparingInt(MutationDetails::getLineNumber);
    }

    private void checkForInlinedCode(Collection<MutationDetails> mutantsToReturn, Collection<MutationDetails> similarMutantsOnSameLine) {
        List<MutationDetails> mutationsInHandlerBlock = similarMutantsOnSameLine.stream().filter(this::isInFinallyBlock).collect(Collectors.toList());
        if (!this.isPossibleToCorrectInlining(mutationsInHandlerBlock)) {
            mutantsToReturn.addAll(similarMutantsOnSameLine);
            return;
        }
        MutationDetails baseMutation = mutationsInHandlerBlock.get(0);
        int firstBlock = (Integer)baseMutation.getBlocks().get(0);
        List<Integer> ids = InlinedFinallyBlockFilter.blocksForMutants(similarMutantsOnSameLine);
        if (ids.stream().anyMatch(Prelude.not(Predicate.isEqual(firstBlock)))) {
            mutantsToReturn.add(InlinedFinallyBlockFilter.makeCombinedMutant(similarMutantsOnSameLine));
        } else {
            mutantsToReturn.addAll(similarMutantsOnSameLine);
        }
    }

    private boolean isInFinallyBlock(MutationDetails m) {
        Optional<MethodTree> maybeMethod = this.currentClass.method(m.getId().getLocation());
        if (maybeMethod.isEmpty()) {
            return false;
        }
        MethodTree method = maybeMethod.get();
        List handlers = method.rawNode().tryCatchBlocks.stream().filter(t -> t.type == null).map(t -> t.handler).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return false;
        }
        AbstractInsnNode mutatedInstruction = method.instruction(m.getInstructionIndex());
        Context context = Context.start(false);
        context = context.store(MUTATED_INSTRUCTION.write(), mutatedInstruction);
        context = context.store(HANDLERS.write(), handlers);
        return IS_IN_HANDLER.matches(method.instructions(), context);
    }

    private boolean isPossibleToCorrectInlining(List<MutationDetails> mutationsInHandlerBlock) {
        if (mutationsInHandlerBlock.size() > 1) {
            LOG.warning("Found more than one mutation similar on same line in a finally block. Can't correct for inlining.");
            return false;
        }
        return !mutationsInHandlerBlock.isEmpty();
    }

    private static MutationDetails makeCombinedMutant(Collection<MutationDetails> value) {
        MutationDetails first = value.iterator().next();
        HashSet indexes = new HashSet();
        FCollection.mapTo(value, MutationDetails::getFirstIndex, indexes);
        MutationIdentifier id = new MutationIdentifier(first.getId().getLocation(), indexes, first.getId().getMutator());
        return new MutationDetails(id, first.getFilename(), first.getDescription(), first.getLineNumber(), InlinedFinallyBlockFilter.blocksForMutants(value));
    }

    private static Function<MutationDetails, LineMutatorPair> toLineMutatorPair() {
        return a -> new LineMutatorPair(a.getLineNumber(), a.getMutator() + a.getDescription());
    }

    private static List<Integer> blocksForMutants(Collection<MutationDetails> mutants) {
        return mutants.stream().flatMap(m -> m.getBlocks().stream()).collect(Collectors.toList());
    }
}

