/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.util.Log;

public abstract class InfiniteLoopFilter
implements MutationInterceptor {
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    abstract SequenceMatcher<AbstractInsnNode> infiniteLoopMatcher();

    abstract boolean couldCauseInfiniteLoop(MethodTree var1, MutationDetails var2);

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        Map buckets = FCollection.bucket(mutations, this.mutationToLocation());
        ArrayList<MutationDetails> willTimeout = new ArrayList<MutationDetails>();
        for (Map.Entry each : buckets.entrySet()) {
            willTimeout.addAll(this.findTimeoutMutants((Location)each.getKey(), (Collection)each.getValue(), m));
        }
        mutations.removeAll(willTimeout);
        return mutations;
    }

    private Collection<MutationDetails> findTimeoutMutants(Location location, Collection<MutationDetails> mutations, Mutater m) {
        Optional<MethodTree> maybeMethod = this.currentClass.method(location);
        if (maybeMethod.isEmpty()) {
            return Collections.emptyList();
        }
        MethodTree method = maybeMethod.get();
        if (method.instructions().isEmpty()) {
            Log.getLogger().warning(String.valueOf(method.asLocation()) + " has no instructions");
            return Collections.emptyList();
        }
        if (this.infiniteLoopMatcher().matches(method.instructions())) {
            return Collections.emptyList();
        }
        ArrayList<MutationDetails> timeouts = new ArrayList<MutationDetails>();
        for (MutationDetails each : mutations) {
            if (!this.couldCauseInfiniteLoop(method, each) || !this.isInfiniteLoop(each, m)) continue;
            timeouts.add(each);
        }
        return timeouts;
    }

    private boolean isInfiniteLoop(MutationDetails each, Mutater m) {
        ClassTree mutantClass = ClassTree.fromBytes(m.getMutation(each.getId()).getBytes());
        Optional<MethodTree> mutantMethod = mutantClass.methods().stream().filter(MethodMatchers.forLocation(each.getId().getLocation())).findFirst();
        return this.infiniteLoopMatcher().matches(mutantMethod.get().instructions());
    }

    private Function<MutationDetails, Location> mutationToLocation() {
        return a -> a.getId().getLocation();
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

