/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import org.pitest.sequence.Consume;
import org.pitest.sequence.EndMatch;
import org.pitest.sequence.Match;
import org.pitest.sequence.NFASequenceMatcher;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Split;
import org.pitest.sequence.State;

public class SequenceQuery<T> {
    private final Partial<T> token;

    SequenceQuery(Partial<T> token) {
        this.token = token;
    }

    public SequenceQuery<T> then(Match<T> next) {
        return this.then(new SequenceQuery<T>(new Literal<T>(next)));
    }

    public SequenceQuery<T> then(SequenceQuery<T> next) {
        Concat<T> concat = new Concat<T>(this.token, next.token);
        return new SequenceQuery<T>(concat);
    }

    public SequenceQuery<T> or(SequenceQuery<T> next) {
        Or<T> or = new Or<T>(this.token, next.token);
        return new SequenceQuery<T>(or);
    }

    public SequenceQuery<T> thenAnyOf(SequenceQuery<T> left, SequenceQuery<T> right) {
        Or<T> or = new Or<T>(left.token, right.token);
        Concat<T> concat = new Concat<T>(this.token, or);
        return new SequenceQuery<T>(concat);
    }

    public SequenceQuery<T> zeroOrMore(SequenceQuery<T> next) {
        Concat<T> concat = new Concat<T>(this.token, new Repeat<T>(next.token));
        return new SequenceQuery<T>(concat);
    }

    public SequenceQuery<T> oneOrMore(SequenceQuery<T> next) {
        Concat<T> concat = new Concat<T>(this.token, new Plus<T>(next.token));
        return new SequenceQuery<T>(concat);
    }

    public SequenceMatcher<T> compile() {
        return this.compile(QueryParams.params());
    }

    public SequenceMatcher<T> compile(QueryParams<T> params) {
        return new NFASequenceMatcher<T>(params.ignoring(), this.token.make(EndMatch.MATCH), params.isDebug());
    }

    static class Plus<T>
    implements Partial<T> {
        final Partial<T> r;

        Plus(Partial<T> r) {
            this.r = r;
        }

        @Override
        public State<T> make(State<T> andThen) {
            Concat<T> concat = new Concat<T>(this.r, new Repeat<T>(this.r));
            return concat.make(andThen);
        }
    }

    static class Repeat<T>
    implements Partial<T> {
        final Partial<T> r;

        Repeat(Partial<T> r) {
            this.r = r;
        }

        @Override
        public State<T> make(State<T> andThen) {
            Split placeHolder = new Split(null, null);
            State<T> right = this.r.make(placeHolder);
            placeHolder.out1 = new Split<T>(right, andThen);
            return placeHolder;
        }
    }

    static class Concat<T>
    implements Partial<T> {
        final Partial<T> left;
        final Partial<T> right;

        Concat(Partial<T> left, Partial<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public State<T> make(State<T> andThen) {
            return this.left.make(this.right.make(andThen));
        }
    }

    static class Or<T>
    implements Partial<T> {
        final Partial<T> left;
        final Partial<T> right;

        Or(Partial<T> left, Partial<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public State<T> make(State<T> andThen) {
            State<T> l = this.left.make(andThen);
            State<T> r = this.right.make(andThen);
            return new Split<T>(l, r);
        }
    }

    static class Literal<T>
    implements Partial<T> {
        final Match<T> c;

        Literal(Match<T> p) {
            this.c = p;
        }

        @Override
        public State<T> make(State<T> andThen) {
            return new Consume<T>(this.c, andThen);
        }
    }

    static interface Partial<T> {
        public State<T> make(State<T> var1);
    }
}

