/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classpath.CodeSource;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.verify.BuildMessage;
import org.pitest.mutationtest.verify.BuildVerifier;

public class DefaultBuildVerifier
implements BuildVerifier {
    private final CodeSource code;

    public DefaultBuildVerifier(CodeSource code) {
        this.code = code;
    }

    @Override
    public List<BuildMessage> verifyBuild() {
        boolean hasMutableCode = this.code.codeTrees().anyMatch(this::isMutable);
        if (!hasMutableCode) {
            return Collections.emptyList();
        }
        this.checkForLineNumbers();
        this.checkForDebugSourceFile();
        return Collections.emptyList();
    }

    private void checkForDebugSourceFile() {
        boolean sourceFile = this.code.codeTrees().anyMatch(this::hasSourceFile);
        if (!sourceFile) {
            throw new PitHelpError(Help.NO_SOURCE_FILE, new Object[]{this.code.codeTrees().findFirst().get().name().asJavaName()});
        }
    }

    private void checkForLineNumbers() {
        boolean lineNumbers = this.code.codeTrees().anyMatch(this::hasLineNumbers);
        if (!lineNumbers) {
            throw new PitHelpError(Help.NO_LINE_NUMBERS, new Object[0]);
        }
    }

    private boolean isMutable(ClassTree classTree) {
        return !classTree.isInterface() && !classTree.isSynthetic();
    }

    private boolean hasLineNumbers(ClassTree classTree) {
        return classTree.methods().stream().anyMatch(m -> m.instructions().stream().anyMatch(n -> n instanceof LineNumberNode));
    }

    private boolean hasSourceFile(ClassTree classTree) {
        return classTree.rawNode().sourceFile != null;
    }
}

