/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.util.Collections;
import java.util.List;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.TestStat;
import org.pitest.coverage.TestStatListener;

public class BasicStatListener
implements TestStatListener {
    private static final int SLOW_LIMIT = 2000;
    private int slowTestCount = 0;
    private TestStat slowestTest = new TestStat(0, null);
    private TestStat largestTest = new TestStat(0, null);

    @Override
    public void accept(CoverageResult cr) {
        if (cr.getExecutionTime() > 2000) {
            ++this.slowTestCount;
        }
        if (cr.getExecutionTime() >= this.slowestTest.stat()) {
            this.slowestTest = new TestStat(cr.getExecutionTime(), cr.getTestUnitDescription());
        }
        if (cr.getNumberOfCoveredBlocks() >= this.largestTest.stat()) {
            this.largestTest = new TestStat(cr.getNumberOfCoveredBlocks(), cr.getTestUnitDescription());
        }
    }

    @Override
    public List<String> messages() {
        if (this.slowestTest.stat() == 0) {
            return Collections.emptyList();
        }
        return List.of(this.slowTestCount + " tests took longer than 2000 ms", "Slowest test (" + this.slowestTest.test().getName() + ") took " + this.slowestTest.stat() + " ms", "Largest test (" + this.largestTest.test().getName() + ") covered " + this.largestTest.stat() + " blocks");
    }

    @Override
    public void end() {
    }
}

