/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;

public class MethodTree {
    private final ClassName owner;
    private final MethodNode rawNode;
    private List<AbstractInsnNode> lazyInstructions;

    public MethodTree(ClassName owner, MethodNode rawNode) {
        this.owner = owner;
        this.rawNode = rawNode;
    }

    public MethodNode rawNode() {
        return this.rawNode;
    }

    public Location asLocation() {
        return Location.location((ClassName)this.owner, (MethodName)MethodName.fromString((String)this.rawNode.name), (String)this.rawNode.desc);
    }

    public AbstractInsnNode realInstructionBefore(int index) {
        AbstractInsnNode candidate = this.instructions().get(index - 1);
        if (candidate.getOpcode() == -1) {
            return this.realInstructionBefore(index - 1);
        }
        return candidate;
    }

    public AbstractInsnNode instruction(int index) {
        return this.instructions().get(index);
    }

    public List<AbstractInsnNode> instructions() {
        if (this.lazyInstructions != null) {
            return this.lazyInstructions;
        }
        return this.createInstructionList();
    }

    public boolean isSynthetic() {
        return (this.rawNode.access & 0x1000) != 0;
    }

    public List<AnnotationNode> annotations() {
        ArrayList<AnnotationNode> annotaions = new ArrayList<AnnotationNode>();
        if (this.rawNode.invisibleAnnotations != null) {
            annotaions.addAll(this.rawNode.invisibleAnnotations);
        }
        if (this.rawNode.visibleAnnotations != null) {
            annotaions.addAll(this.rawNode.visibleAnnotations);
        }
        return annotaions;
    }

    private List<AbstractInsnNode> createInstructionList() {
        LinkedList<AbstractInsnNode> list = new LinkedList<AbstractInsnNode>();
        ListIterator<AbstractInsnNode> it = this.rawNode.instructions.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        this.lazyInstructions = new ArrayList<AbstractInsnNode>(list);
        return this.lazyInstructions;
    }
}

