/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;

public class EqualsPerformanceShortcutFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    static final SequenceMatcher<AbstractInsnNode> ALWAYS_FALSE = QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(88)).then(InstructionMatchers.opCode(167).and(InstructionMatchers.debug("goto"))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        List doNotTouch = FCollection.filter(mutations, this.inEqualsMethod().negate());
        if (doNotTouch.size() != mutations.size()) {
            List inEquals = FCollection.filter(mutations, this.inEqualsMethod());
            List<MutationDetails> filtered = this.filter(inEquals, m);
            doNotTouch.addAll(filtered);
        }
        return doNotTouch;
    }

    private List<MutationDetails> filter(List<MutationDetails> inEquals, Mutater m) {
        Location equalsMethod = inEquals.get(0).getId().getLocation();
        Optional<MethodTree> maybeEquals = this.currentClass.methods().stream().filter(MethodMatchers.forLocation(equalsMethod)).findFirst();
        return inEquals.stream().filter(this.isShortcutEquals(maybeEquals.get(), m).negate()).collect(Collectors.toList());
    }

    private Predicate<MutationDetails> isShortcutEquals(MethodTree tree, Mutater m) {
        return a -> this.shortCutEquals(tree, (MutationDetails)a, m);
    }

    private Boolean shortCutEquals(MethodTree tree, MutationDetails a, Mutater m) {
        if (!this.mutatesAConditionalJump(tree, a.getInstructionIndex())) {
            return false;
        }
        ClassTree mutant = ClassTree.fromBytes(m.getMutation(a.getId()).getBytes());
        MethodTree mutantEquals = mutant.methods().stream().filter(MethodMatchers.forLocation(tree.asLocation())).findFirst().get();
        return ALWAYS_FALSE.matches(mutantEquals.instructions());
    }

    private boolean mutatesAConditionalJump(MethodTree tree, int index) {
        AbstractInsnNode mutatedInsns = tree.instruction(index);
        return InstructionMatchers.aConditionalJump().test(null, (Object)mutatedInsns);
    }

    private Predicate<MutationDetails> inEqualsMethod() {
        return a -> {
            Location loc = a.getId().getLocation();
            return loc.getMethodDesc().equals("(Ljava/lang/Object;)Z") && loc.getMethodName().equals((Object)MethodName.fromString((String)"equals"));
        };
    }

    @Override
    public void end() {
    }
}

