/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class TryWithResourcesFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final Slot<Boolean> FOUND = Slot.create(Boolean.class);
    private static final SequenceMatcher<AbstractInsnNode> TRY_WITH_RESOURCES = QueryStart.match((Match)Match.never()).or(TryWithResourcesFilter.javac11()).or(TryWithResourcesFilter.javac8()).or(TryWithResourcesFilter.ecj()).or(TryWithResourcesFilter.ecjAddSuppressedCheck()).then(TryWithResourcesFilter.containMutation(FOUND)).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));
    private ClassTree currentClass;

    private static SequenceQuery<AbstractInsnNode> javac11() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.closeCall()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.aGoto()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anAStore()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.addSuppressedCall()).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> javac8() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ifNull()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.ifNull()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.closeCall()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.aGoto()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anAStore()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.addSuppressedCall()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.aGoto()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.closeCall()).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecj() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.closeCall()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(InstructionMatchers.opCode(191).and(TryWithResourcesFilter.mutationPoint())).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anAStore()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.ifNonNull()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anAStore()).then(TryWithResourcesFilter.aGoto()).then(TryWithResourcesFilter.aLabel()).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecjAddSuppressedCheck() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ifNonNull()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anAStore()).then(TryWithResourcesFilter.aGoto()).then(TryWithResourcesFilter.aLabel()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anALoad()).then(InstructionMatchers.opCode(165).and(TryWithResourcesFilter.mutationPoint())).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.anALoad()).then(TryWithResourcesFilter.addSuppressedCall()).then(TryWithResourcesFilter.aLabel()).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.mutatesTryWithResourcesScaffolding()));
    }

    private Predicate<MutationDetails> mutatesTryWithResourcesScaffolding() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.method(a.getId().getLocation()).orElseThrow(() -> new IllegalStateException("Could not find method for mutant " + a));
            if (method.rawNode().tryCatchBlocks.size() <= 1) {
                return false;
            }
            AbstractInsnNode mutatedInstruction = method.instruction(instruction);
            Context context = Context.start(method.instructions(), (boolean)false);
            context.store(MUTATED_INSTRUCTION.write(), (Object)mutatedInstruction);
            return TRY_WITH_RESOURCES.matches(method.instructions(), context);
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    private static Match<AbstractInsnNode> aLabel() {
        return InstructionMatchers.isA(LabelNode.class);
    }

    private static Match<AbstractInsnNode> anALoad() {
        return InstructionMatchers.opCode(25).and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> aGoto() {
        return InstructionMatchers.opCode(167).and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> addSuppressedCall() {
        return InstructionMatchers.methodCallNamed("addSuppressed").and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> anAStore() {
        return InstructionMatchers.opCode(58).and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> closeCall() {
        return InstructionMatchers.methodCallNamed("close").and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> ifNonNull() {
        return InstructionMatchers.opCode(199).and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> ifNull() {
        return InstructionMatchers.opCode(198).and(TryWithResourcesFilter.mutationPoint());
    }

    private static Match<AbstractInsnNode> mutationPoint() {
        return InstructionMatchers.recordTarget((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read(), (SlotWrite<Boolean>)FOUND.write());
    }

    private static Match<AbstractInsnNode> containMutation(Slot<Boolean> found) {
        return (c, t) -> c.retrieve(found.read()).isPresent();
    }
}

