/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.EmptyObjectReturnValsMutator;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

class EmptyReturnsFilter
implements MutationInterceptor {
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final SequenceMatcher<AbstractInsnNode> CONSTANT_ZERO = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(EmptyReturnsFilter.isZeroConstant()).then(InstructionMatchers.methodCallNamed("valueOf")).then(InstructionMatchers.isInstruction((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private static final Set<Integer> ZERO_CONSTANTS = new HashSet<Integer>();
    private ClassTree currentClass;

    EmptyReturnsFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.isEquivalent(m)));
    }

    private static Match<AbstractInsnNode> isZeroConstant() {
        return (context, node) -> ZERO_CONSTANTS.contains(node.getOpcode());
    }

    private Predicate<MutationDetails> isEquivalent(Mutater m) {
        return new Predicate<MutationDetails>(){

            @Override
            public boolean test(MutationDetails a) {
                int mutatedInstruction;
                if (!MUTATOR_IDS.contains(a.getMutator())) {
                    return false;
                }
                MethodTree method = EmptyReturnsFilter.this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get();
                return this.returnsZeroValue(method, mutatedInstruction = a.getInstructionIndex()) != false || this.returnsEmptyString(method, mutatedInstruction) || this.returns(method, mutatedInstruction, "java/util/Optional", "empty") || this.returns(method, mutatedInstruction, "java/util/stream/Stream", "empty") || this.returns(method, mutatedInstruction, "java/util/Collections", "emptyList") || this.returns(method, mutatedInstruction, "java/util/Collections", "emptySet") || this.returns(method, mutatedInstruction, "java/util/List", "of") || this.returns(method, mutatedInstruction, "java/util/Set", "of");
            }

            private Boolean returnsZeroValue(MethodTree method, int mutatedInstruction) {
                Context context = Context.start(method.instructions(), (boolean)false);
                context.store(MUTATED_INSTRUCTION.write(), (Object)method.instruction(mutatedInstruction));
                return CONSTANT_ZERO.matches(method.instructions(), context);
            }

            private boolean returns(MethodTree method, int mutatedInstruction, String owner, String name) {
                AbstractInsnNode node = method.realInstructionBefore(mutatedInstruction);
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode call = (MethodInsnNode)node;
                    return call.owner.equals(owner) && call.name.equals(name) && this.takesNoArguments(call.desc);
                }
                return false;
            }

            private boolean takesNoArguments(String desc) {
                return Type.getArgumentTypes(desc).length == 0;
            }

            private boolean returnsEmptyString(MethodTree method, int mutatedInstruction) {
                AbstractInsnNode node = method.realInstructionBefore(mutatedInstruction);
                if (node instanceof LdcInsnNode) {
                    LdcInsnNode ldc = (LdcInsnNode)node;
                    return "".equals(ldc.cst);
                }
                return false;
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    static {
        ZERO_CONSTANTS.add(3);
        ZERO_CONSTANTS.add(9);
        ZERO_CONSTANTS.add(11);
        ZERO_CONSTANTS.add(14);
        MUTATOR_IDS.add(EmptyObjectReturnValsMutator.EMPTY_RETURNS.getGloballyUniqueId());
        MUTATOR_IDS.add(BooleanFalseReturnValsMutator.FALSE_RETURNS.getGloballyUniqueId());
    }
}

