/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;

public class ForEachLoopFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Slot<List<AbstractInsnNode>> LOOP_INSTRUCTIONS = Slot.createList(AbstractInsnNode.class);
    private static final SequenceMatcher<AbstractInsnNode> ITERATOR_LOOP = ForEachLoopFilter.conditionalAtStart().or(ForEachLoopFilter.conditionalAtEnd()).or(ForEachLoopFilter.arrayConditionalAtEnd()).or(ForEachLoopFilter.arrayConditionalAtStart()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));
    private ClassTree currentClass;
    private Map<MethodTree, Set<AbstractInsnNode>> cache;

    private static SequenceQuery<AbstractInsnNode> conditionalAtEnd() {
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(ForEachLoopFilter.aMethodCallReturningAnIterator().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.gotoLabel(loopEnd.write())).then(InstructionMatchers.aLabelNode(loopStart.write())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "next").and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.labelNode(loopEnd.read())).then(InstructionMatchers.opCode(25)).then(ForEachLoopFilter.hasNextMethodCall().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.aConditionalJumpTo(loopStart).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> conditionalAtStart() {
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(ForEachLoopFilter.aMethodCallReturningAnIterator().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.aLabelNode(loopStart.write())).then(InstructionMatchers.opCode(25)).then(ForEachLoopFilter.hasNextMethodCall().and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.jumpsTo(loopEnd.write())).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "next").and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(167).and(InstructionMatchers.jumpsTo(loopStart.read()))).then(InstructionMatchers.labelNode(loopEnd.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> arrayConditionalAtEnd() {
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        Slot<Integer> counter = Slot.create(Integer.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(190).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(54)).then(InstructionMatchers.opCode(3).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.anIStore(counter.write()).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.gotoLabel(loopEnd.write())).then(InstructionMatchers.aLabelNode(loopStart.write())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.incrementsVariable(counter.read()).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.labelNode(loopEnd.read())).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.aConditionalJumpTo(loopStart).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> arrayConditionalAtStart() {
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        Slot<Integer> counter = Slot.create(Integer.class);
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.opCode(190).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(54)).then(InstructionMatchers.opCode(3).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.anIStore(counter.write()).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.aLabelNode(loopStart.write())).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.opCode(21)).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.jumpsTo(loopEnd.write())).and(ForEachLoopFilter.mutationPoint())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(InstructionMatchers.incrementsVariable(counter.read()).and(ForEachLoopFilter.mutationPoint())).then(InstructionMatchers.opCode(167).and(InstructionMatchers.jumpsTo(loopStart.read()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static Match<AbstractInsnNode> hasNextMethodCall() {
        return InstructionMatchers.methodCallTo(ClassName.fromString((String)"java/util/Iterator"), "hasNext");
    }

    private static Match<AbstractInsnNode> aMethodCallReturningAnIterator() {
        return InstructionMatchers.methodCallThatReturns(ClassName.fromClass(Iterator.class));
    }

    private static Match<AbstractInsnNode> mutationPoint() {
        return (c, t) -> {
            c.retrieve(LOOP_INSTRUCTIONS.read()).get().add((AbstractInsnNode)t);
            return Result.result(true, c);
        };
    }

    private static Match<AbstractInsnNode> containMutation(Slot<Boolean> found) {
        return (c, t) -> Result.result(c.retrieve(found.read()).isPresent(), c);
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.cache = new IdentityHashMap<MethodTree, Set<AbstractInsnNode>>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(this.mutatesIteratorLoopPlumbing().negate()).collect(Collectors.toList());
    }

    private Predicate<MutationDetails> mutatesIteratorLoopPlumbing() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.method(a.getId().getLocation()).get();
            if (!this.mightContainForLoop(method.instructions())) {
                return false;
            }
            AbstractInsnNode mutatedInstruction = method.instruction(instruction);
            Set toAvoid = this.cache.computeIfAbsent(method, this::findLoopInstructions);
            return toAvoid.contains(mutatedInstruction);
        };
    }

    private Set<AbstractInsnNode> findLoopInstructions(MethodTree method) {
        Context context = Context.start(false).store(LOOP_INSTRUCTIONS.write(), new ArrayList());
        return ITERATOR_LOOP.contextMatches(method.instructions(), context).stream().flatMap(c -> c.retrieve(LOOP_INSTRUCTIONS.read()).get().stream()).collect(Collectors.toSet());
    }

    private boolean mightContainForLoop(List<AbstractInsnNode> instructions) {
        return instructions.stream().anyMatch(i -> ForEachLoopFilter.hasNextMethodCall().or(InstructionMatchers.opCode(190)).test(null, (AbstractInsnNode)i).result());
    }

    @Override
    public void end() {
        this.currentClass = null;
        this.cache = null;
    }
}

