/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

public class TryWithResourcesFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Slot<List<LabelNode>> HANDLERS = Slot.createList(LabelNode.class);
    private static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    private static final Slot<AbstractInsnNode> END = Slot.create(AbstractInsnNode.class);
    private ClassTree currentClass;
    private Map<MethodTree, List<Region>> cache;
    private static final SequenceMatcher<AbstractInsnNode> TRY_WITH_RESOURCES = TryWithResourcesFilter.javac11().or(TryWithResourcesFilter.javac()).or(TryWithResourcesFilter.ecj()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(TryWithResourcesFilter.aLabel().and(TryWithResourcesFilter.isLabel(HANDLERS.read()).negate()))).withDebug(false));

    private static SequenceQuery<AbstractInsnNode> javac11() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.closeSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeSequence(false)).then(InstructionMatchers.opCode(167)).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.addSuppressedMethodCall().and(InstructionMatchers.debug("add suppressed"))).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(191).and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> javac() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.javacCloseSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(191)).then(InstructionMatchers.opCode(58)).then(TryWithResourcesFilter.javacCloseSequence(false)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(191).and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecj() {
        return QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ecjCloseSequence(true)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(TryWithResourcesFilter.ecjCloseAndThrow()).zeroOrMore(TryWithResourcesFilter.ecjCloseSuppress()).then(TryWithResourcesFilter.ecjSuppress()).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(191).and(TryWithResourcesFilter.recordPoint(END, true))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseSuppress() {
        return TryWithResourcesFilter.ecjCloseSequence(false).then(InstructionMatchers.opCode(167)).then(TryWithResourcesFilter.ecjSuppress()).then(TryWithResourcesFilter.ecjCloseAndThrow());
    }

    private static SequenceQuery<AbstractInsnNode> ecjSuppress() {
        return QueryStart.match(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(199)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(58)).then(InstructionMatchers.opCode(167)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(165)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.addSuppressedMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseSequence(boolean record) {
        return QueryStart.match(InstructionMatchers.opCode(25).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(198)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> ecjCloseAndThrow() {
        return QueryStart.match(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(198)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeMethodCall()).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(191));
    }

    private static SequenceQuery<AbstractInsnNode> javacCloseSequence(boolean record) {
        return TryWithResourcesFilter.methodSequence(record).or(TryWithResourcesFilter.fullSequence(record)).or(TryWithResourcesFilter.omittedNullCheckSequence(record)).or(TryWithResourcesFilter.optimalSequence(record));
    }

    private static SequenceQuery<AbstractInsnNode> methodSequence(boolean record) {
        return QueryStart.match(InstructionMatchers.opCode(25).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(198)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeResourceMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> fullSequence(boolean record) {
        return QueryStart.match(InstructionMatchers.opCode(25).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(198)).then(TryWithResourcesFilter.omittedNullCheckSequence(false));
    }

    private static SequenceQuery<AbstractInsnNode> omittedNullCheckSequence(boolean record) {
        return QueryStart.match(InstructionMatchers.opCode(25).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(198)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeMethodCall()).then(InstructionMatchers.opCode(167).and(InstructionMatchers.debug("goto"))).then(TryWithResourcesFilter.isLabel(HANDLERS.read()).and(InstructionMatchers.debug("handler"))).then(InstructionMatchers.opCode(58).and(InstructionMatchers.debug("store"))).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.addSuppressedMethodCall()).then(InstructionMatchers.opCode(167)).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeMethodCall().and(InstructionMatchers.debug("end of sequence")));
    }

    private static SequenceQuery<AbstractInsnNode> optimalSequence(boolean record) {
        return QueryStart.match(InstructionMatchers.opCode(25).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeResourceMethodCall());
    }

    private static SequenceQuery<AbstractInsnNode> closeSequence(boolean record) {
        return QueryStart.match(TryWithResourcesFilter.closeMethodCall().and(TryWithResourcesFilter.recordPoint(START, record))).or(QueryStart.match(InstructionMatchers.opCode(198).and(TryWithResourcesFilter.recordPoint(START, record))).then(InstructionMatchers.opCode(25)).then(TryWithResourcesFilter.closeMethodCall()));
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.cache = new IdentityHashMap<MethodTree, List<Region>>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.mutatesTryWithResourcesScaffolding()));
    }

    private Predicate<MutationDetails> mutatesTryWithResourcesScaffolding() {
        return a -> {
            int instruction = a.getInstructionIndex();
            MethodTree method = this.currentClass.method(a.getId().getLocation()).orElseThrow(() -> new IllegalStateException("Could not find method for mutant " + a));
            if (method.rawNode().tryCatchBlocks.size() <= 1) {
                return false;
            }
            List regions = this.cache.computeIfAbsent(method, this::computeRegions);
            return regions.stream().anyMatch(r -> instruction >= method.instructions().indexOf(r.start) && instruction <= method.instructions().indexOf(r.end));
        };
    }

    private List<Region> computeRegions(MethodTree method) {
        List handlers = method.rawNode().tryCatchBlocks.stream().filter(t -> "java/lang/Throwable".equals(t.type)).filter(t -> t.handler != null).map(t -> t.handler).collect(Collectors.toList());
        Context context = Context.start(false);
        context = context.store(HANDLERS.write(), handlers);
        List<Region> regions = TRY_WITH_RESOURCES.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
        return regions;
    }

    @Override
    public void end() {
        this.currentClass = null;
        this.cache = null;
    }

    private static Match<AbstractInsnNode> aLabel() {
        return InstructionMatchers.isA(LabelNode.class);
    }

    private static Match<AbstractInsnNode> isLabel(SlotRead<List<LabelNode>> read) {
        return TryWithResourcesFilter.aLabel().and((c, t) -> Result.result(((List)c.retrieve(read).get()).contains(t), c));
    }

    private static Match<AbstractInsnNode> closeMethodCall() {
        return InstructionMatchers.methodCallNamed("close").and(InstructionMatchers.opCode(185).or(InstructionMatchers.opCode(182))).and(InstructionMatchers.methodDescEquals("()V"));
    }

    private static Match<AbstractInsnNode> closeResourceMethodCall() {
        return InstructionMatchers.methodCallNamed("$closeResource").and(InstructionMatchers.methodDescEquals("(Ljava/lang/Throwable;Ljava/lang/AutoCloseable;)V"));
    }

    private static Match<AbstractInsnNode> addSuppressedMethodCall() {
        return InstructionMatchers.methodCallNamed("addSuppressed").and(InstructionMatchers.methodDescEquals("(Ljava/lang/Throwable;)V"));
    }

    private static Match<AbstractInsnNode> recordPoint(Slot<AbstractInsnNode> slot, boolean record) {
        if (!record) {
            return (c, t) -> Result.result(true, c);
        }
        return InstructionMatchers.writeNodeToSlot(slot.write(), AbstractInsnNode.class);
    }

    static class Region {
        final AbstractInsnNode start;
        final AbstractInsnNode end;

        Region(AbstractInsnNode start, AbstractInsnNode end) {
            this.start = start;
            this.end = end;
        }
    }
}

