/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.timeout;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.intercept.timeout.InfiniteLoopFilter;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;

public class InfiniteForLoopFilter
extends InfiniteLoopFilter {
    private static final boolean DEBUG = false;
    static final SequenceMatcher<AbstractInsnNode> INFINITE_LOOP = InfiniteForLoopFilter.countingLoopWithoutWriteConditionalAtStart().or(InfiniteForLoopFilter.countingLoopWithoutWriteConditionAtEnd()).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()).withDebug(false));

    @Override
    SequenceMatcher<AbstractInsnNode> infiniteLoopMatcher() {
        return INFINITE_LOOP;
    }

    @Override
    boolean couldCauseInfiniteLoop(MethodTree method, MutationDetails each) {
        AbstractInsnNode instruction = method.instruction(each.getInstructionIndex());
        return instruction.getOpcode() == 132;
    }

    private static SequenceQuery<AbstractInsnNode> countingLoopWithoutWriteConditionalAtStart() {
        Slot<Integer> counterVariable = Slot.create(Integer.class);
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIntegerConstant().and(InstructionMatchers.debug("constant"))).zeroOrMore(QueryStart.match(InstructionMatchers.opCode(96))).then(InstructionMatchers.anIStore(counterVariable.write()).and(InstructionMatchers.debug("counter"))).zeroOrMore(QueryStart.match(InstructionMatchers.opCode(21).or(InstructionMatchers.opCode(25).or(InstructionMatchers.opCode(54)).or(InstructionMatchers.methodCall())))).then(InstructionMatchers.aLabelNode(loopStart.write()).and(InstructionMatchers.debug("label"))).then(InstructionMatchers.anILoadOf(counterVariable.read()).and(InstructionMatchers.debug("load"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop(counterVariable)).zeroOrMore(QueryStart.match(InstructionMatchers.opCode(21).or(InstructionMatchers.opCode(25).or(InstructionMatchers.methodCall())))).then(InstructionMatchers.aConditionalJump().and(InstructionMatchers.debug("jump"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop(counterVariable)).then(InstructionMatchers.jumpsTo(loopStart.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> countingLoopWithoutWriteConditionAtEnd() {
        Slot<Integer> counterVariable = Slot.create(Integer.class);
        Slot<LabelNode> loopStart = Slot.create(LabelNode.class);
        Slot<LabelNode> loopEnd = Slot.create(LabelNode.class);
        return QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.anIntegerConstant()).then(InstructionMatchers.anIStore(counterVariable.write()).and(InstructionMatchers.debug("counter"))).then(InstructionMatchers.isA(LabelNode.class)).then(InstructionMatchers.gotoLabel(loopEnd.write())).then(InstructionMatchers.aLabelNode(loopStart.write()).and(InstructionMatchers.debug("loop start"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop(counterVariable)).then(InstructionMatchers.labelNode(loopEnd.read()).and(InstructionMatchers.debug("loop end"))).then(InstructionMatchers.anILoadOf(counterVariable.read()).and(InstructionMatchers.debug("read"))).zeroOrMore(InfiniteForLoopFilter.doesNotBreakLoop(counterVariable)).then(InstructionMatchers.jumpsTo(loopStart.read()).and(InstructionMatchers.debug("jump"))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction()));
    }

    private static SequenceQuery<AbstractInsnNode> doesNotBreakLoop(Slot<Integer> counterVariable) {
        return QueryStart.match(InstructionMatchers.anIStoreTo(counterVariable.read()).and(InstructionMatchers.debug("broken by store")).or(InstructionMatchers.incrementsVariable(counterVariable.read())).negate());
    }
}

