/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.sequence;

import org.pitest.sequence.Context;
import org.pitest.sequence.Result;

@FunctionalInterface
public interface Match<T> {
    public Result test(Context var1, T var2);

    public static <T> Match<T> always() {
        return (c, t) -> Result.result(true, c);
    }

    public static <T> Match<T> never() {
        return (c, t) -> Result.result(false, c);
    }

    public static <T> Match<T> isEqual(Object targetRef) {
        return (c, t) -> Result.result(targetRef.equals(t), c);
    }

    default public Match<T> and(Match<T> other) {
        return (c, t) -> {
            Result r = this.test(c, t);
            if (!r.result()) {
                return r;
            }
            return other.test(r.context(), t);
        };
    }

    default public Match<T> negate() {
        return (c, t) -> {
            Result r = this.test(c, t);
            if (!r.result()) {
                return Result.result(true, r.context());
            }
            return Result.result(false, c);
        };
    }

    default public Match<T> or(Match<T> other) {
        return (c, t) -> {
            Result r = this.test(c, t);
            if (r.result()) {
                return r;
            }
            return other.test(c, t);
        };
    }
}

