/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.returns.EmptyObjectReturnValsMutator;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;

class EmptyReturnsFilter
implements MutationInterceptor {
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    private static final Slot<Integer> LOCAL_VAR = Slot.create(Integer.class);
    static final SequenceQuery<AbstractInsnNode> CONSTANT_ZERO = QueryStart.match(EmptyReturnsFilter.isZeroConstant()).then(InstructionMatchers.methodCallNamed("valueOf"));
    static final SequenceQuery<AbstractInsnNode> CONSTANT_FALSE = QueryStart.match(InstructionMatchers.getStatic("java/lang/Boolean", "FALSE"));
    static final SequenceMatcher<AbstractInsnNode> ZERO_VALUES = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(CONSTANT_ZERO.or(CONSTANT_FALSE).or(QueryStart.match(EmptyReturnsFilter.loadsEmptyReturnOntoStack()))).then(InstructionMatchers.isInstruction(MUTATED_INSTRUCTION.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));
    static final SequenceMatcher<AbstractInsnNode> INDIRECT_ZERO_VALUES = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(EmptyReturnsFilter.loadsEmptyReturnOntoStack()).then(EmptyReturnsFilter.aStoreTo(LOCAL_VAR)).zeroOrMore(QueryStart.match(EmptyReturnsFilter.aStoreTo(LOCAL_VAR).negate())).then(OpcodeMatchers.ALOAD.and(InstructionMatchers.variableMatches(LOCAL_VAR.read()))).then(InstructionMatchers.isInstruction(MUTATED_INSTRUCTION.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction().or(InstructionMatchers.isA(LabelNode.class))));
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private static final Set<Integer> ZERO_CONSTANTS = new HashSet<Integer>();
    private ClassTree currentClass;

    EmptyReturnsFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.isEquivalent(m)));
    }

    private static Match<AbstractInsnNode> aStoreTo(Slot<Integer> variable) {
        return OpcodeMatchers.ASTORE.and(InstructionMatchers.aVariableAccess(variable.write()));
    }

    private static Match<AbstractInsnNode> isZeroConstant() {
        return (context, node) -> Result.result(ZERO_CONSTANTS.contains(node.getOpcode()), context);
    }

    private Predicate<MutationDetails> isEquivalent(Mutater m) {
        return new Predicate<MutationDetails>(){

            @Override
            public boolean test(MutationDetails a) {
                int mutatedInstruction;
                if (!MUTATOR_IDS.contains(a.getMutator())) {
                    return false;
                }
                MethodTree method = EmptyReturnsFilter.this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get();
                return this.returnsZeroValue(ZERO_VALUES, method, mutatedInstruction = a.getInstructionIndex()) != false || this.returnsZeroValue(INDIRECT_ZERO_VALUES, method, mutatedInstruction) != false || this.returnsEmptyString(method, mutatedInstruction);
            }

            private Boolean returnsZeroValue(SequenceMatcher<AbstractInsnNode> sequence, MethodTree method, int mutatedInstruction) {
                Context context = Context.start();
                context = context.store(MUTATED_INSTRUCTION.write(), method.instruction(mutatedInstruction));
                return sequence.matches(method.instructions(), context);
            }

            private boolean returnsEmptyString(MethodTree method, int mutatedInstruction) {
                AbstractInsnNode node = method.realInstructionBefore(mutatedInstruction);
                if (node instanceof LdcInsnNode) {
                    LdcInsnNode ldc = (LdcInsnNode)node;
                    return "".equals(ldc.cst);
                }
                return false;
            }
        };
    }

    private static Match<AbstractInsnNode> loadsEmptyReturnOntoStack() {
        return EmptyReturnsFilter.noArgsCall("java/util/Optional", "empty").or(EmptyReturnsFilter.noArgsCall("java/util/stream/Stream", "empty")).or(EmptyReturnsFilter.noArgsCall("java/util/Collections", "emptyList")).or(EmptyReturnsFilter.noArgsCall("java/util/Collections", "emptyMap")).or(EmptyReturnsFilter.noArgsCall("java/util/Collections", "emptySet")).or(EmptyReturnsFilter.noArgsCall("java/util/List", "of")).or(EmptyReturnsFilter.noArgsCall("java/util/Set", "of"));
    }

    private static Match<AbstractInsnNode> noArgsCall(String owner, String name) {
        return InstructionMatchers.methodCallTo(ClassName.fromString((String)owner), name).and(EmptyReturnsFilter.takesNoArgs());
    }

    private static Match<AbstractInsnNode> takesNoArgs() {
        return (c, node) -> {
            if (node instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)node;
                return Result.result(Type.getArgumentTypes(call.desc).length == 0, c);
            }
            return Result.result(false, c);
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    static {
        ZERO_CONSTANTS.add(3);
        ZERO_CONSTANTS.add(9);
        ZERO_CONSTANTS.add(11);
        ZERO_CONSTANTS.add(14);
        MUTATOR_IDS.add(EmptyObjectReturnValsMutator.EMPTY_RETURNS.getGloballyUniqueId());
        MUTATOR_IDS.add(BooleanFalseReturnValsMutator.FALSE_RETURNS.getGloballyUniqueId());
    }
}

