/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionInterceptor;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

public class StringSwitchFilter
extends RegionInterceptor {
    static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    static final Slot<AbstractInsnNode> END = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> STRING_SWITCH = QueryStart.any(AbstractInsnNode.class).then(OpcodeMatchers.ICONST_M1.and(StringSwitchFilter.store(START.write()))).then(OpcodeMatchers.ISTORE).then(OpcodeMatchers.ALOAD).then(InstructionMatchers.methodCallTo(ClassName.fromClass(String.class), "hashCode")).then(OpcodeMatchers.LOOKUPSWITCH.or(OpcodeMatchers.TABLESWITCH)).then(InstructionMatchers.isA(LabelNode.class)).oneOrMore(StringSwitchFilter.switchBranchSequence().then(InstructionMatchers.isA(LabelNode.class))).then(StringSwitchFilter.switchBranchSequenceNoGoto()).then(InstructionMatchers.isA(LabelNode.class)).then(OpcodeMatchers.ILOAD.and(StringSwitchFilter.store(END.write()))).then(OpcodeMatchers.LOOKUPSWITCH.or(OpcodeMatchers.TABLESWITCH)).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }

    private static SequenceQuery<AbstractInsnNode> switchBranchSequenceNoGoto() {
        return QueryStart.match(OpcodeMatchers.ALOAD).then(OpcodeMatchers.LDC).then(InstructionMatchers.methodCallTo(ClassName.fromClass(String.class), "equals")).then(OpcodeMatchers.IFEQ).then(InstructionMatchers.anIntegerConstant().or(OpcodeMatchers.BIPUSH).or(OpcodeMatchers.SIPUSH)).then(OpcodeMatchers.ISTORE);
    }

    private static SequenceQuery<AbstractInsnNode> switchBranchSequence() {
        return StringSwitchFilter.switchBranchSequenceNoGoto().then(OpcodeMatchers.GOTO);
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        List<Region> regions = STRING_SWITCH.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(START.read()).get(), c.retrieve(END.read()).get())).collect(Collectors.toList());
        return regions;
    }
}

