/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.autoconfig;

import java.util.logging.Logger;
import org.pitest.mutationtest.config.ConfigurationUpdater;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.util.Log;

public class AutoSetThreads
implements ConfigurationUpdater {
    private static final Logger LOG = Log.getLogger();

    @Override
    public void updateConfig(ReportOptions toModify) {
        int cores = this.getCores();
        cores = cores >= 8 ? Math.round((float)cores / 1.5f) : Math.max(1, cores - 1);
        LOG.info("Overriding configured number of threads (" + toModify.getNumberOfThreads() + ") to be " + cores);
        toModify.setNumberOfThreads(cores);
    }

    public Feature provides() {
        return Feature.named((String)"auto_threads").withOnByDefault(false).withDescription(this.description());
    }

    public String description() {
        return "Auto set number of threads based on machine";
    }

    int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }
}

