/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.tooling.DirectorySourceLocator;
import org.pitest.util.Unchecked;

public class SmartSourceLocator
implements SourceLocator {
    private static final int MAX_DEPTH = 4;
    private final Collection<SourceLocator> children;
    private final Charset inputCharset;

    public SmartSourceLocator(Collection<Path> roots, Charset inputCharset) {
        this.inputCharset = inputCharset;
        List childDirs = FCollection.flatMap(roots, this.collectChildren(4));
        childDirs.addAll(roots);
        this.children = FCollection.map((Iterable)childDirs, f -> new DirectorySourceLocator((Path)f, this.inputCharset));
    }

    private Function<Path, Collection<Path>> collectChildren(int depth) {
        return a -> this.collectDirectories((Path)a, depth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Path> collectDirectories(Path root, int depth) {
        try {
            if (!Files.exists(root, new LinkOption[0])) {
                return Collections.emptyList();
            }
            try (Stream<Path> matches = Files.find(root, depth, (unused, attributes) -> attributes.isDirectory(), new FileVisitOption[0]);){
                Collection collection = matches.collect(Collectors.toList());
                return collection;
            }
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    @Override
    public Optional<Reader> locate(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.children) {
            Optional<Reader> reader = each.locate(classes, fileName);
            if (!reader.isPresent()) continue;
            return reader;
        }
        return Optional.empty();
    }
}

