/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import org.pitest.coverage.ClassLines;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.MutationResultList;
import org.pitest.mutationtest.report.html.MutationTotals;
import org.pitest.util.Log;

public class MutationTestSummaryData {
    private final String fileName;
    private final Set<String> mutators = new TreeSet<String>();
    private final Collection<MutationResult> mutations = new ArrayList<MutationResult>();
    private final Set<ClassLines> classes = new HashSet<ClassLines>();
    private long numberOfCoveredLines;

    public MutationTestSummaryData(String fileName, Collection<MutationResult> results, Collection<String> mutators, Collection<ClassLines> classes, long numberOfCoveredLines) {
        this.fileName = fileName;
        this.mutations.addAll(results);
        this.mutators.addAll(mutators);
        this.classes.addAll(classes);
        this.numberOfCoveredLines = numberOfCoveredLines;
    }

    public MutationTotals getTotals() {
        MutationTotals mt = new MutationTotals();
        mt.addFiles(1L);
        mt.addMutations(this.getNumberOfMutations());
        mt.addMutationsDetetcted(this.getNumberOfMutationsDetected());
        mt.addLines(this.getNumberOfLines());
        mt.addLinesCovered(this.numberOfCoveredLines);
        mt.addMutationsWithCoverage(this.getNumberOfMutationsWithCoverage());
        return mt;
    }

    private long getNumberOfMutationsWithCoverage() {
        return this.mutations.stream().filter(it -> it.getStatus().hasCoverage()).count();
    }

    public String getPackageName() {
        Iterator<ClassLines> iterator = this.getMutatedClasses().iterator();
        if (!iterator.hasNext()) {
            Log.getLogger().log(Level.WARNING, "Can't get package name for " + this.fileName + ".There is no mutated classes. It may happen if you are using report-aggregate goal to merge reports using a dedicated maven project and the dependency that contains the mutated code is missing");
            return "default";
        }
        String packageName = iterator.next().name().asJavaName();
        int lastDot = packageName.lastIndexOf(46);
        return lastDot > 0 ? packageName.substring(0, lastDot) : "default";
    }

    public void add(MutationTestSummaryData data) {
        this.mutations.addAll(data.mutations);
        this.mutators.addAll(data.getMutators());
        int classesBefore = this.classes.size();
        this.classes.addAll(data.classes);
        if (classesBefore < this.classes.size()) {
            this.numberOfCoveredLines += data.numberOfCoveredLines;
        }
    }

    public Collection<TestInfo> getTests() {
        HashSet<TestInfo> uniqueTests = new HashSet<TestInfo>();
        FCollection.flatMapTo(this.mutations, this.mutationToTargettedTests(), uniqueTests);
        return uniqueTests;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Collection<ClassLines> getMutatedClasses() {
        return this.classes;
    }

    public Set<String> getMutators() {
        return this.mutators;
    }

    public MutationResultList getResults() {
        return new MutationResultList(this.mutations);
    }

    public Collection<ClassLines> getClasses() {
        return this.classes;
    }

    private int getNumberOfLines() {
        return (Integer)FCollection.fold(this.accumulateCodeLines(), (Object)0, this.classes);
    }

    private BiFunction<Integer, ClassLines, Integer> accumulateCodeLines() {
        return (a, b) -> a + b.getNumberOfCodeLines();
    }

    private long getNumberOfMutations() {
        return this.mutations.size();
    }

    private long getNumberOfMutationsDetected() {
        int count = 0;
        for (MutationResult each : this.mutations) {
            if (!each.getStatus().isDetected()) continue;
            ++count;
        }
        return count;
    }

    private Function<MutationResult, Iterable<TestInfo>> mutationToTargettedTests() {
        return a -> a.getDetails().getTestsInOrder();
    }
}

