/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.predicates.IsInnerClass;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class JavaElementsResolver {
    private static final Logger logger = LoggerFactory.getLogger(JavaElementsResolver.class);
    private static final IsInnerClass isInnerClass = new IsInnerClass();
    private final TestDescriptor engineDescriptor;
    private final Set<ElementResolver> resolvers;

    JavaElementsResolver(TestDescriptor engineDescriptor, Set<ElementResolver> resolvers) {
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
    }

    void resolveClass(Class<?> testClass) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveContainerWithParents(testClass);
        resolvedDescriptors.forEach(this::resolveChildren);
        if (resolvedDescriptors.isEmpty()) {
            logger.debug(() -> String.format("Class '%s' could not be resolved.", testClass.getName()));
        }
    }

    void resolveMethod(Class<?> testClass, Method testMethod) {
        Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass);
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(testMethod, potentialParents);
        if (resolvedDescriptors.isEmpty()) {
            logger.debug(() -> String.format("Method '%s' could not be resolved.", testMethod.toGenericString()));
        }
        this.logMultipleTestDescriptorsForSingleElement(testMethod, resolvedDescriptors);
    }

    private Set<TestDescriptor> resolveContainerWithParents(Class<?> testClass) {
        if (isInnerClass.test(testClass)) {
            Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass.getDeclaringClass());
            return this.resolveForAllParents(testClass, potentialParents);
        }
        return this.resolveForAllParents(testClass, Collections.singleton(this.engineDescriptor));
    }

    void resolveUniqueId(UniqueId uniqueId) {
        if ("junit-jupiter".equals(uniqueId.getEngineId().orElse(null))) {
            Deque<TestDescriptor> resolvedDescriptors = this.resolveAllSegments(uniqueId);
            this.handleResolvedDescriptorsForUniqueId(uniqueId, resolvedDescriptors);
        }
    }

    private Deque<TestDescriptor> resolveAllSegments(UniqueId uniqueId) {
        List<UniqueId.Segment> segments = uniqueId.getSegments();
        LinkedList<TestDescriptor> resolvedDescriptors = new LinkedList<TestDescriptor>();
        resolvedDescriptors.addFirst(this.engineDescriptor);
        for (int index = 1; index < segments.size() && resolvedDescriptors.size() == index; ++index) {
            UniqueId.Segment segment = segments.get(index);
            TestDescriptor parent = (TestDescriptor)resolvedDescriptors.getLast();
            UniqueId partialUniqueId = parent.getUniqueId().append(segment);
            Optional<TestDescriptor> resolvedDescriptor = this.findTestDescriptorByUniqueId(partialUniqueId);
            if (!resolvedDescriptor.isPresent()) {
                resolvedDescriptor = this.resolvers.stream().map(resolver -> resolver.resolveUniqueId(segment, parent)).filter(Optional::isPresent).map(Optional::get).findFirst();
                resolvedDescriptor.ifPresent(parent::addChild);
            }
            resolvedDescriptor.ifPresent(resolvedDescriptors::addLast);
        }
        return resolvedDescriptors;
    }

    private void handleResolvedDescriptorsForUniqueId(UniqueId uniqueId, Deque<TestDescriptor> resolvedDescriptors) {
        List<UniqueId.Segment> segments = uniqueId.getSegments();
        int numSegmentsToResolve = segments.size() - 1;
        int numSegmentsResolved = resolvedDescriptors.size() - 1;
        if (numSegmentsResolved == 0) {
            logger.warn(() -> String.format("Unique ID '%s' could not be resolved.", uniqueId));
        } else if (numSegmentsResolved != numSegmentsToResolve) {
            if (resolvedDescriptors.getLast() instanceof Filterable) {
                ((Filterable)((Object)resolvedDescriptors.getLast())).getDynamicDescendantFilter().allow(uniqueId);
            } else {
                logger.warn(() -> {
                    List unresolved = segments.subList(1, segments.size());
                    unresolved = unresolved.subList(numSegmentsResolved, unresolved.size());
                    return String.format("Unique ID '%s' could only be partially resolved. All resolved segments will be executed; however, the following segments could not be resolved: %s", uniqueId, unresolved);
                });
            }
        } else {
            this.resolveChildren(resolvedDescriptors.getLast());
        }
    }

    private Set<TestDescriptor> resolveContainerWithChildren(Class<?> containerClass, Set<TestDescriptor> potentialParents) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(containerClass, potentialParents);
        resolvedDescriptors.forEach(this::resolveChildren);
        return resolvedDescriptors;
    }

    private Set<TestDescriptor> resolveForAllParents(AnnotatedElement element, Set<TestDescriptor> potentialParents) {
        HashSet<TestDescriptor> resolvedDescriptors = new HashSet<TestDescriptor>();
        potentialParents.forEach(parent -> resolvedDescriptors.addAll(this.resolve(element, (TestDescriptor)parent)));
        resolvedDescriptors.stream().filter(Filterable.class::isInstance).map(Filterable.class::cast).forEach(testDescriptor -> testDescriptor.getDynamicDescendantFilter().allowAll());
        return resolvedDescriptors;
    }

    private void resolveChildren(TestDescriptor descriptor) {
        if (descriptor instanceof ClassTestDescriptor) {
            Class<?> testClass = ((ClassTestDescriptor)descriptor).getTestClass();
            this.resolveContainedMethods(descriptor, testClass);
            this.resolveContainedNestedClasses(descriptor, testClass);
        }
    }

    private void resolveContainedNestedClasses(TestDescriptor containerDescriptor, Class<?> clazz) {
        List<Class<?>> nestedClassesCandidates = ReflectionUtils.findNestedClasses(clazz, isInnerClass);
        nestedClassesCandidates.forEach(nestedClass -> this.resolveContainerWithChildren((Class<?>)nestedClass, Collections.singleton(containerDescriptor)));
    }

    private void resolveContainedMethods(TestDescriptor containerDescriptor, Class<?> testClass) {
        List<Method> testMethodCandidates = ReflectionUtils.findMethods(testClass, ReflectionUtils::isNotPrivate);
        testMethodCandidates.forEach(method -> this.resolve((AnnotatedElement)method, containerDescriptor));
    }

    private Set<TestDescriptor> resolve(AnnotatedElement element, TestDescriptor parent) {
        Set<TestDescriptor> descriptors = this.resolvers.stream().map(resolver -> this.tryToResolveWithResolver(element, parent, (ElementResolver)resolver)).filter(testDescriptors -> !testDescriptors.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
        this.logMultipleTestDescriptorsForSingleElement(element, descriptors);
        return descriptors;
    }

    private Set<TestDescriptor> tryToResolveWithResolver(AnnotatedElement element, TestDescriptor parent, ElementResolver resolver) {
        Set<TestDescriptor> resolvedDescriptors = resolver.resolveElement(element, parent);
        LinkedHashSet<TestDescriptor> result = new LinkedHashSet<TestDescriptor>();
        resolvedDescriptors.forEach(testDescriptor -> {
            Optional<TestDescriptor> existingTestDescriptor = this.findTestDescriptorByUniqueId(testDescriptor.getUniqueId());
            if (existingTestDescriptor.isPresent()) {
                result.add(existingTestDescriptor.get());
            } else {
                parent.addChild((TestDescriptor)testDescriptor);
                result.add((TestDescriptor)testDescriptor);
            }
        });
        return result;
    }

    private Optional<TestDescriptor> findTestDescriptorByUniqueId(UniqueId uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }

    private void logMultipleTestDescriptorsForSingleElement(AnnotatedElement element, Set<TestDescriptor> descriptors) {
        if (descriptors.size() > 1 && element instanceof Method) {
            Method method = (Method)element;
            logger.warn(() -> String.format("Possible configuration error: method [%s] resulted in multiple TestDescriptors %s. This is typically the result of annotating a method with multiple competing annotations such as @Test, @RepeatedTest, @ParameterizedTest, @TestFactory, etc.", method.toGenericString(), descriptors.stream().map(d -> d.getClass().getName()).collect(Collectors.toList())));
        }
    }
}

