/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodExtensionContext;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestMethodTestDescriptor
extends MethodBasedTestDescriptor {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public TestMethodTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, testClass, testMethod);
    }

    TestMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod) {
        super(uniqueId, displayName, testClass, testMethod);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) throws Exception {
        ExtensionRegistry registry = this.populateNewExtensionRegistry(context);
        Object testInstance = context.getTestInstanceProvider().getTestInstance(Optional.of(registry));
        OpenTest4JAwareThrowableCollector throwableCollector = new OpenTest4JAwareThrowableCollector();
        MethodExtensionContext extensionContext = new MethodExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfigurationParameters(), testInstance, throwableCollector);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    protected ExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context) {
        return ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.getTestMethod());
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.invokeBeforeEachCallbacks(context);
        if (throwableCollector.isEmpty()) {
            this.invokeBeforeEachMethods(context);
            if (throwableCollector.isEmpty()) {
                this.invokeBeforeTestExecutionCallbacks(context);
                if (throwableCollector.isEmpty()) {
                    this.invokeTestMethod(context, dynamicTestExecutor);
                }
                this.invokeAfterTestExecutionCallbacks(context);
            }
            this.invokeAfterEachMethods(context);
        }
        this.invokeAfterEachCallbacks(context);
        throwableCollector.assertEmpty();
        return context;
    }

    private void invokeBeforeEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, callback) -> () -> callback.beforeEach(extensionContext), BeforeEachCallback.class);
    }

    private void invokeBeforeEachMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, adapter) -> () -> adapter.invokeBeforeEachMethod((ExtensionContext)extensionContext, registry), BeforeEachMethodAdapter.class);
    }

    private void invokeBeforeTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context, (extensionContext, callback) -> () -> callback.beforeTestExecution(extensionContext), BeforeTestExecutionCallback.class);
    }

    private <T extends Extension> void invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(JupiterEngineExecutionContext context, BiFunction<ExtensionContext, T, ThrowableCollector.Executable> generator, Class<T> type) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (Extension callback : registry.getExtensions(type)) {
            ThrowableCollector.Executable executable = generator.apply(extensionContext, (ExtensionContext)callback);
            throwableCollector.execute(executable);
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        throwableCollector.execute(() -> {
            try {
                Method testMethod = this.getTestMethod();
                Object instance = extensionContext.getRequiredTestInstance();
                executableInvoker.invoke(testMethod, instance, extensionContext, context.getExtensionRegistry());
            }
            catch (Throwable throwable) {
                this.invokeTestExecutionExceptionHandlers(context.getExtensionRegistry(), extensionContext, throwable);
            }
        });
    }

    private void invokeTestExecutionExceptionHandlers(ExtensionRegistry registry, ExtensionContext context, Throwable ex) {
        this.invokeTestExecutionExceptionHandlers(ex, registry.getReversedExtensions(TestExecutionExceptionHandler.class), context);
    }

    private void invokeTestExecutionExceptionHandlers(Throwable ex, List<TestExecutionExceptionHandler> handlers, ExtensionContext context) {
        if (handlers.isEmpty()) {
            ExceptionUtils.throwAsUncheckedException(ex);
        }
        try {
            handlers.remove(0).handleTestExecutionException(context, ex);
        }
        catch (Throwable t) {
            this.invokeTestExecutionExceptionHandlers(t, handlers, context);
        }
    }

    private void invokeAfterTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, callback) -> () -> callback.afterTestExecution(extensionContext), AfterTestExecutionCallback.class);
    }

    private void invokeAfterEachMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, adapter) -> () -> adapter.invokeAfterEachMethod((ExtensionContext)extensionContext, registry), AfterEachMethodAdapter.class);
    }

    private void invokeAfterEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(context, (extensionContext, callback) -> () -> callback.afterEach(extensionContext), AfterEachCallback.class);
    }

    private <T extends Extension> void invokeAllAfterMethodsOrCallbacks(JupiterEngineExecutionContext context, BiFunction<ExtensionContext, T, ThrowableCollector.Executable> generator, Class<T> type) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(type).forEach(callback -> {
            ThrowableCollector.Executable executable = (ThrowableCollector.Executable)generator.apply(extensionContext, callback);
            throwableCollector.execute(executable);
        });
    }
}

