/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateExtensionContext;
import org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateTestDescriptor
extends MethodBasedTestDescriptor
implements Filterable {
    private final DynamicDescendantFilter dynamicDescendantFilter = new DynamicDescendantFilter();

    public TestTemplateTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod) {
        super(uniqueId, testClass, templateMethod);
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) throws Exception {
        ExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.getTestMethod());
        Object testInstance = context.getExtensionContext().getTestInstance().orElse(null);
        TestTemplateExtensionContext extensionContext = new TestTemplateExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfigurationParameters(), testInstance);
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).build();
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ExtensionContext extensionContext = context.getExtensionContext();
        List<TestTemplateInvocationContextProvider> providers = this.validateProviders(extensionContext, context.getExtensionRegistry());
        AtomicInteger invocationIndex = new AtomicInteger();
        providers.stream().flatMap(provider -> provider.provideTestTemplateInvocationContexts(extensionContext)).map(invocationContext -> this.createInvocationTestDescriptor((TestTemplateInvocationContext)invocationContext, invocationIndex.incrementAndGet())).filter(Optional::isPresent).map(Optional::get).forEach(invocationTestDescriptor -> this.execute(dynamicTestExecutor, (TestDescriptor)invocationTestDescriptor));
        this.validateWasAtLeastInvokedOnce(invocationIndex.get());
        return context;
    }

    private List<TestTemplateInvocationContextProvider> validateProviders(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        List providers = extensionRegistry.stream(TestTemplateInvocationContextProvider.class).filter(provider -> provider.supportsTestTemplate(extensionContext)).collect(Collectors.toList());
        return Preconditions.notEmpty(providers, () -> String.format("You must register at least one %s that supports @TestTemplate method [%s]", TestTemplateInvocationContextProvider.class.getSimpleName(), this.getTestMethod()));
    }

    private Optional<TestDescriptor> createInvocationTestDescriptor(TestTemplateInvocationContext invocationContext, int index) {
        UniqueId uniqueId = this.getUniqueId().append("test-template-invocation", "#" + index);
        if (this.getDynamicDescendantFilter().test(uniqueId)) {
            return Optional.of(new TestTemplateInvocationTestDescriptor(uniqueId, this.getTestClass(), this.getTestMethod(), invocationContext, index));
        }
        return Optional.empty();
    }

    private void execute(Node.DynamicTestExecutor dynamicTestExecutor, TestDescriptor testDescriptor) {
        this.addChild(testDescriptor);
        dynamicTestExecutor.execute(testDescriptor);
    }

    private void validateWasAtLeastInvokedOnce(int invocationIndex) {
        Preconditions.condition(invocationIndex > 0, () -> "No supporting " + TestTemplateInvocationContextProvider.class.getSimpleName() + " provided an invocation context");
    }
}

