/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit5;

import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;

public class JUnit5TestUnit
extends AbstractTestUnit {
    private final Class<?> testClass;
    private final TestIdentifier testIdentifier;

    public JUnit5TestUnit(Class<?> testClass, TestIdentifier testIdentifier) {
        super(new Description(testIdentifier.getDisplayName(), testClass));
        this.testClass = testClass;
        this.testIdentifier = testIdentifier;
    }

    public void execute(final ResultCollector resultCollector) {
        Launcher launcher = LauncherFactory.create();
        LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectUniqueId(this.testIdentifier.getUniqueId())).build();
        launcher.registerTestExecutionListeners(new TestExecutionListener(){

            @Override
            public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                testIdentifier.getSource().ifPresent(testSource -> {
                    if (testSource instanceof MethodSource) {
                        resultCollector.notifySkipped(new Description(testIdentifier.getDisplayName(), JUnit5TestUnit.this.testClass));
                    }
                });
            }

            @Override
            public void executionStarted(TestIdentifier testIdentifier) {
                testIdentifier.getSource().ifPresent(testSource -> {
                    if (testSource instanceof MethodSource) {
                        resultCollector.notifyStart(new Description(testIdentifier.getDisplayName(), JUnit5TestUnit.this.testClass));
                    }
                });
            }

            @Override
            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                testIdentifier.getSource().ifPresent(testSource -> {
                    if (testSource instanceof MethodSource) {
                        Optional<Throwable> throwable = testExecutionResult.getThrowable();
                        if (TestExecutionResult.Status.ABORTED == testExecutionResult.getStatus()) {
                            resultCollector.notifyEnd(new Description(testIdentifier.getDisplayName(), JUnit5TestUnit.this.testClass));
                        } else if (throwable.isPresent()) {
                            resultCollector.notifyEnd(new Description(testIdentifier.getDisplayName(), JUnit5TestUnit.this.testClass), throwable.get());
                        } else {
                            resultCollector.notifyEnd(new Description(testIdentifier.getDisplayName(), JUnit5TestUnit.this.testClass));
                        }
                    }
                });
            }
        });
        launcher.execute(launcherDiscoveryRequest, new TestExecutionListener[0]);
    }
}

