/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.CompositeTestExecutionListener;
import org.junit.platform.launcher.core.StreamInterceptor;

class StreamInterceptingTestExecutionListener
implements CompositeTestExecutionListener.EagerTestExecutionListener {
    private final Optional<StreamInterceptor> stdoutInterceptor;
    private final Optional<StreamInterceptor> stderrInterceptor;
    private final BiConsumer<TestIdentifier, ReportEntry> reporter;

    static Optional<StreamInterceptingTestExecutionListener> create(ConfigurationParameters configurationParameters, BiConsumer<TestIdentifier, ReportEntry> reporter) {
        Optional<Object> stderrInterceptor;
        boolean captureStdout = configurationParameters.getBoolean("junit.platform.output.capture.stdout").orElse(false);
        boolean captureStderr = configurationParameters.getBoolean("junit.platform.output.capture.stderr").orElse(false);
        if (!captureStdout && !captureStderr) {
            return Optional.empty();
        }
        int maxSize = configurationParameters.get("junit.platform.output.capture.maxBuffer", Integer::valueOf).orElse(0x400000);
        Optional<Object> stdoutInterceptor = captureStdout ? StreamInterceptor.registerStdout(maxSize) : Optional.empty();
        Optional<Object> optional = stderrInterceptor = captureStderr ? StreamInterceptor.registerStderr(maxSize) : Optional.empty();
        if (!stdoutInterceptor.isPresent() && captureStdout || !stderrInterceptor.isPresent() && captureStderr) {
            stdoutInterceptor.ifPresent(StreamInterceptor::unregister);
            stderrInterceptor.ifPresent(StreamInterceptor::unregister);
            return Optional.empty();
        }
        return Optional.of(new StreamInterceptingTestExecutionListener(stdoutInterceptor, stderrInterceptor, reporter));
    }

    private StreamInterceptingTestExecutionListener(Optional<StreamInterceptor> stdoutInterceptor, Optional<StreamInterceptor> stderrInterceptor, BiConsumer<TestIdentifier, ReportEntry> reporter) {
        this.stdoutInterceptor = stdoutInterceptor;
        this.stderrInterceptor = stderrInterceptor;
        this.reporter = reporter;
    }

    void unregister() {
        this.stdoutInterceptor.ifPresent(StreamInterceptor::unregister);
        this.stderrInterceptor.ifPresent(StreamInterceptor::unregister);
    }

    @Override
    public void executionJustStarted(TestIdentifier testIdentifier) {
        this.stdoutInterceptor.ifPresent(StreamInterceptor::capture);
        this.stderrInterceptor.ifPresent(StreamInterceptor::capture);
    }

    @Override
    public void executionJustFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String err;
        HashMap<String, String> map = new HashMap<String, String>();
        String out = this.stdoutInterceptor.map(StreamInterceptor::consume).orElse("");
        if (StringUtils.isNotBlank(out)) {
            map.put("stdout", out);
        }
        if (StringUtils.isNotBlank(err = this.stderrInterceptor.map(StreamInterceptor::consume).orElse(""))) {
            map.put("stderr", err);
        }
        if (!map.isEmpty()) {
            this.reporter.accept(testIdentifier, ReportEntry.from(map));
        }
    }
}

