/*
 * Decompiled with CFR 0.152.
 */
package org.piwik;

import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;

public class ResponseData {
    private Map<String, List<String>> headerData;
    private static final Logger LOGGER = Logger.getLogger(ResponseData.class.getName());

    public ResponseData(HttpURLConnection connection) {
        this.headerData = connection.getHeaderFields();
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String key : this.headerData.keySet()) {
            List<String> headerParts = this.headerData.get(key);
            StringBuilder cookieInfo = new StringBuilder();
            for (String part : headerParts) {
                cookieInfo.append(part);
            }
            if (key == null && cookieInfo.toString().equals("")) {
                LOGGER.log(Level.FINE, "No more headers, not proceeding");
                return null;
            }
            if (key == null) {
                LOGGER.log(Level.FINE, "The header value contains the server's HTTP version, not proceeding");
                continue;
            }
            if (key.equals("Set-Cookie")) {
                List<HttpCookie> httpCookies = HttpCookie.parse(cookieInfo.toString());
                for (HttpCookie h : httpCookies) {
                    Cookie c = new Cookie(h.getName(), h.getValue());
                    c.setComment(h.getComment());
                    if (h.getDomain() != null) {
                        c.setDomain(h.getDomain());
                    }
                    c.setMaxAge(Long.valueOf(h.getMaxAge()).intValue());
                    c.setPath(h.getPath());
                    c.setSecure(h.getSecure());
                    c.setVersion(h.getVersion());
                    cookies.add(c);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "The provided key ({0}) with value ({1}) were not processed because the key is unknown", new Object[]{key, cookieInfo});
        }
        return cookies;
    }
}

