/*
 * Decompiled with CFR 0.152.
 */
package org.piwik;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.piwik.BrowserPlugins;
import org.piwik.PiwikException;
import org.piwik.PiwikTracker;
import org.piwik.ResponseData;

public class SimplePiwikTracker
implements PiwikTracker {
    private Random random = new Random(new Date().getTime());
    private static final Logger LOGGER = Logger.getLogger(SimplePiwikTracker.class.getName());
    public static final int VERSION = 1;
    public static final int MAX_CUSTOM_VARIABLES = 5;
    public static final int MAX_CUSTOM_VARIABLE_LENGTH = 100;
    private URL apiurl;
    private String debugAppendUrl = "";
    private String userAgent;
    private String language;
    private Date localTime;
    private Map<BrowserPlugins, Boolean> plugins = new EnumMap<BrowserPlugins, Boolean>(BrowserPlugins.class);
    private Map<String, String> pageCustomVar = new HashMap<String, String>(5);
    private Map<String, String> visitorCustomVar = new HashMap<String, String>(5);
    private Date forcedDatetime;
    private String tokenAuth;
    private Cookie requestCookie;
    private String visitorId;
    private int width;
    private int height;
    private String pageCustomData;
    private String visitorCustomData;
    private int idSite;
    private String pageUrl;
    private String ip;
    private URL urlReferrer;

    public SimplePiwikTracker(String apiUrl) throws PiwikException {
        this.setApiurl(apiUrl);
        this.setVisitorId(this.md5(UUID.randomUUID().toString()).substring(0, 16));
    }

    public SimplePiwikTracker(int idSite, String apiUrl, HttpServletRequest request) throws PiwikException {
        this(apiUrl);
        this.idSite = idSite;
        this.readRequestInfos(request);
    }

    public final String getVisitorId() {
        return this.visitorId;
    }

    public final void readRequestInfos(HttpServletRequest request) throws PiwikException {
        if (request != null) {
            this.setUrlReferrer(request.getHeader("Referer"));
            this.setUserAgent(request.getHeader("User-Agent"));
            this.setPageUrl(request.getRequestURL().toString());
            this.setIp(request.getRemoteAddr());
            this.setAcceptLanguage(request.getLocale());
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (!cookie.getName().equals("piwik_visitor")) continue;
                    LOGGER.log(Level.FINE, "found tracking cookie");
                    this.setRequestCookie(cookie);
                }
            }
        }
    }

    public final void setAcceptLanguage(String language) {
        this.language = language;
    }

    public final void setAcceptLanguage(Locale locale) {
        String localeLanguage = null;
        if (locale != null) {
            localeLanguage = locale.getLanguage();
        }
        this.setAcceptLanguage(localeLanguage);
    }

    public final void setApiurl(String apiurl) throws PiwikException {
        try {
            this.setApiurl(new URL(apiurl));
        }
        catch (MalformedURLException e) {
            throw new PiwikException("Could not parse given url: " + apiurl, e);
        }
    }

    public final void setApiurl(URL apiurl) throws PiwikException {
        if (apiurl == null) {
            throw new PiwikException("You must provide the Piwik Tracker URL! e.g. http://your-website.org/piwik/\"");
        }
        if (apiurl.getPath().endsWith("piwik.php") || apiurl.getPath().endsWith("piwik-proxy.php")) {
            this.apiurl = apiurl;
        } else {
            try {
                this.apiurl = new URL(apiurl, apiurl.getPath() + "/piwik.php");
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "MalformedURLException", e);
            }
        }
    }

    public final void setCustomData(String customData) {
        this.pageCustomData = customData;
    }

    public final void setDebugAppendUrl(String debugAppendUrl) {
        this.debugAppendUrl = debugAppendUrl == null ? "" : debugAppendUrl;
    }

    public final void setForcedDatetime(Date forcedDatetime) {
        this.forcedDatetime = forcedDatetime;
    }

    public final void setIp(String ip) {
        this.ip = ip;
    }

    public final void setIdSite(int idSite) {
        this.idSite = idSite;
    }

    public final void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public final void setResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final boolean setRequestCookie(Cookie requestCookie) {
        Cookie tobeset = null;
        if (requestCookie != null && requestCookie.getName().equals("piwik_visitor")) {
            tobeset = requestCookie;
        }
        this.requestCookie = tobeset;
        return this.requestCookie != null;
    }

    public final void setTokenAuth(String tokenAuth) {
        this.tokenAuth = tokenAuth;
    }

    public final void setUrlReferrer(String urlReferrer) throws PiwikException {
        try {
            this.urlReferrer = urlReferrer == null ? null : new URL(this.apiurl, urlReferrer);
        }
        catch (MalformedURLException e) {
            throw new PiwikException("Could not parse referrer url: " + urlReferrer, e);
        }
    }

    public final void setUrlReferrer(URL urlReferrer) {
        this.urlReferrer = urlReferrer;
    }

    public final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public final void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public final int setPageCustomVariable(String name, String value) throws PiwikException {
        if (!this.pageCustomVar.containsKey(name) && this.pageCustomVar.size() >= 100) {
            throw new PiwikException("Max size of custom variables are reached. You can only put up to 100 custom variables to a request.");
        }
        if (name.length() > 100) {
            throw new PiwikException("Parameter \"name\" exceeds maximum length of 100. Given length is " + name.length());
        }
        if (value.length() > 100) {
            throw new PiwikException("Parameter \"value\" exceeds maximum length of 100. Given length is " + name.length());
        }
        this.pageCustomVar.put(name, value);
        return this.pageCustomVar.size();
    }

    public final int setVisitorCustomVariable(String name, String value) throws PiwikException {
        if (!this.visitorCustomVar.containsKey(name) && this.visitorCustomVar.size() >= 100) {
            throw new PiwikException("Max size of custom variables are reached. You can only put up to 100 custom variables to a request.");
        }
        if (name.length() > 100) {
            throw new PiwikException("Parameter \"name\" exceeds maximum length of 100. Given length is " + name.length());
        }
        if (value.length() > 100) {
            throw new PiwikException("Parameter \"value\" exceeds maximum length of 100. Given length is " + name.length());
        }
        this.visitorCustomVar.put(name, value);
        return this.visitorCustomVar.size();
    }

    public final void clearCustomVariables() {
        this.pageCustomVar.clear();
    }

    public final void setPlugin(BrowserPlugins plugin, boolean enabled) {
        this.plugins.put(plugin, enabled);
    }

    public final void clearPluginList() {
        this.plugins.clear();
    }

    public final void setLocalTime(String time) throws PiwikException {
        Date date = null;
        if (time != null) {
            try {
                date = new SimpleDateFormat("HH:mm:ss").parse(time);
            }
            catch (ParseException e) {
                throw new PiwikException("Error while parsing given time '" + time + "' to a date object", e);
            }
        }
        this.setLocalTime(date);
    }

    public final void setLocalTime(Date time) {
        this.localTime = time;
    }

    public final String getGeneralQuery() {
        String withPageCustomVar;
        String withVisitorCustomVar;
        String withLocalTime;
        String withAuthtoken;
        URL rootURL = this.apiurl;
        String rootQuery = rootURL.getQuery();
        String withIdsite = this.addParameter(rootQuery, "idsite", this.idSite);
        String withRec = this.addParameter(withIdsite, "rec", 1);
        String withApiVersion = this.addParameter(withRec, "apiv", 1);
        String withURL = this.addParameter(withApiVersion, "url", this.pageUrl);
        String withURLReferrer = this.addParameter(withURL, "urlref", this.urlReferrer);
        String withVisitorId = this.addParameter(withURLReferrer, "_id", this.visitorId);
        String withReferrer = this.addParameter(withVisitorId, "ref", this.urlReferrer);
        String withReferrerForcedTimestamp = this.addParameter(withReferrer, "_refts", this.forcedDatetime);
        String withIp = this.addParameter(withReferrerForcedTimestamp, "cip", this.ip);
        String withForcedTimestamp = this.addParameter(withIp, "cdt", this.forcedDatetime == null ? null : new SimpleDateFormat("yyyyMMdd HH:mm:ssZ").format(this.forcedDatetime));
        String withPlugins = withAuthtoken = this.addParameter(withForcedTimestamp, "token_auth", this.tokenAuth);
        for (Map.Entry<BrowserPlugins, Boolean> entry : this.plugins.entrySet()) {
            withPlugins = this.addParameter(withPlugins, entry.getKey().toString(), entry.getValue());
        }
        if (this.localTime == null) {
            withLocalTime = withPlugins;
        } else {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(this.localTime);
            String withHour = this.addParameter(withPlugins, "h", c.get(11));
            String withMinute = this.addParameter(withHour, "m", c.get(12));
            withLocalTime = this.addParameter(withMinute, "s", c.get(13));
        }
        String withResolution = this.width > 0 && this.height > 0 ? this.addParameter(withLocalTime, "res", this.width + "x" + this.height) : withLocalTime;
        String withCookieInfo = this.addParameter(withResolution, "cookie", this.requestCookie != null);
        String withVisitorCustomData = this.addParameter(withCookieInfo, "data", this.visitorCustomData);
        if (this.visitorCustomVar.isEmpty()) {
            withVisitorCustomVar = withVisitorCustomData;
        } else {
            HashMap customVariables = new HashMap();
            int i = 0;
            for (Map.Entry<String, String> entry : this.visitorCustomVar.entrySet()) {
                ++i;
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getKey());
                list.add(entry.getValue());
                customVariables.put(Integer.toString(i), list);
            }
            JSONArray json = new JSONArray();
            json.put(customVariables);
            String jsonString = json.toString().substring(1, json.toString().length() - 1);
            withVisitorCustomVar = this.addParameter(withVisitorCustomData, "_cvar", jsonString);
        }
        String withPageCustomData = this.addParameter(withVisitorCustomVar, "data", this.pageCustomData);
        if (this.pageCustomVar.isEmpty()) {
            withPageCustomVar = withPageCustomData;
        } else {
            HashMap customVariables = new HashMap();
            int i = 0;
            for (Map.Entry<String, String> entry : this.pageCustomVar.entrySet()) {
                ++i;
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getKey());
                list.add(entry.getValue());
                customVariables.put(Integer.toString(i), list);
            }
            JSONArray json = new JSONArray();
            json.put(customVariables);
            String jsonString = json.toString().substring(1, json.toString().length() - 1);
            withPageCustomVar = this.addParameter(withPageCustomData, "cvar", jsonString);
        }
        String withRand = this.addParameter(withPageCustomVar, "r", String.valueOf(this.random.nextDouble()).substring(2, 8));
        return withRand + this.debugAppendUrl;
    }

    private URL makeURL(String queryString) throws MalformedURLException {
        return new URL(this.apiurl, this.apiurl.getPath() + "?" + queryString);
    }

    private String addParameter(String rootQuery, String name, int value) {
        return this.addParameter(rootQuery, name, String.valueOf(value), true);
    }

    private String addParameter(String rootQuery, String name, URL value) {
        return this.addParameter(rootQuery, name, value == null ? null : value.toExternalForm(), true);
    }

    private String addParameter(String rootQuery, String name, Date value) {
        return this.addParameter(rootQuery, name, value == null ? null : String.valueOf(value.getTime()), true);
    }

    private String addParameter(String rootQuery, String name, boolean selection) {
        return this.addParameter(rootQuery, name, String.valueOf(selection), true);
    }

    private String addParameter(String rootQuery, String name, String value) {
        return this.addParameter(rootQuery, name, value, true);
    }

    private String addParameter(String rootQuery, String name, String value, boolean ignoreNull) {
        String output;
        if (name == null && value == null && rootQuery != null && !rootQuery.trim().isEmpty() || value == null && ignoreNull) {
            output = rootQuery;
        } else if (name != null && rootQuery != null && !rootQuery.trim().isEmpty() && value != null) {
            output = rootQuery + "&" + name + "=" + this.urlencode(value);
        } else if (rootQuery != null && !rootQuery.trim().isEmpty() && value != null) {
            output = rootQuery + "&" + this.urlencode(value);
        } else if (name != null && value != null) {
            output = name + "=" + this.urlencode(value);
        } else if (value != null) {
            output = this.urlencode(value);
        } else {
            output = rootQuery;
            LOGGER.log(Level.WARNING, "value == null!");
        }
        return output;
    }

    private String urlencode(String input) {
        String output;
        try {
            output = URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Error while encoding url", e);
            output = input;
        }
        return output;
    }

    private String md5(String input) {
        String retVal = "";
        try {
            byte[] b = MessageDigest.getInstance("MD5").digest(input.getBytes());
            BigInteger bi = new BigInteger(1, b);
            retVal = bi.toString(16);
            while (retVal.length() < 32) {
                retVal = "0" + retVal;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Error while creating a md5 hash", e);
        }
        return retVal;
    }

    @Override
    public final URL getGoalTrackURL(String goal) {
        URL output = null;
        try {
            String globalQuery = this.getGeneralQuery();
            String resultQuery = this.addParameter(globalQuery, "idgoal", goal);
            output = this.makeURL(resultQuery);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error while building track url", e);
        }
        return output;
    }

    @Override
    public final URL getGoalTrackURL(String goal, String revenue) {
        URL output = null;
        try {
            String globalQuery = this.getGeneralQuery();
            String qoalQuery = this.addParameter(globalQuery, "idgoal", goal);
            String resultQuery = this.addParameter(qoalQuery, "revenue", revenue);
            output = this.makeURL(resultQuery);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error while building track url", e);
        }
        return output;
    }

    @Override
    public final URL getDownloadTrackURL(String downloadurl) {
        URL output = null;
        try {
            String globalQuery = this.getGeneralQuery();
            String resultQuery = this.addParameter(globalQuery, "download", downloadurl);
            output = this.makeURL(resultQuery);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error while building track url", e);
        }
        return output;
    }

    @Override
    public final URL getLinkTrackURL(String linkurl) {
        URL output = null;
        try {
            String globalQuery = this.getGeneralQuery();
            String resultQuery = this.addParameter(globalQuery, "link", linkurl);
            output = this.makeURL(resultQuery);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error while building track url", e);
        }
        return output;
    }

    @Override
    public final URL getPageTrackURL(String pagename) {
        URL output = null;
        try {
            String globalQuery = this.getGeneralQuery();
            String resultQuery = this.addParameter(globalQuery, "action_name", pagename);
            output = this.makeURL(resultQuery);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error while building track url", e);
        }
        return output;
    }

    public final ResponseData sendRequest(URL destination) throws PiwikException {
        ResponseData responseData = null;
        if (destination != null) {
            try {
                List<Cookie> cookies;
                LOGGER.log(Level.FINE, "try to open piwik request url: {0}", destination);
                HttpURLConnection connection = (HttpURLConnection)destination.openConnection();
                connection.setInstanceFollowRedirects(false);
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(600);
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.setRequestProperty("Accept-Language", this.language);
                if (this.requestCookie != null) {
                    connection.setRequestProperty("Cookie", this.requestCookie.getName() + "=" + this.requestCookie.getValue());
                }
                if ((cookies = (responseData = new ResponseData(connection)).getCookies()).size() > 0 && cookies.get(cookies.size() - 1).getName().lastIndexOf("XDEBUG") == -1 && cookies.get(cookies.size() - 1).getValue().lastIndexOf("XDEBUG") == -1) {
                    this.requestCookie = cookies.get(cookies.size() - 1);
                }
                if (connection.getResponseCode() != 200) {
                    LOGGER.log(Level.WARNING, "Warning:{0} {1}", new Object[]{connection.getResponseCode(), connection.getResponseMessage()});
                    throw new PiwikException("error:" + connection.getResponseCode() + " " + connection.getResponseMessage());
                }
                connection.disconnect();
            }
            catch (IOException e) {
                throw new PiwikException("Error while sending request to piwik", e);
            }
        }
        return responseData;
    }

    public String getCustomData() {
        return this.pageCustomData;
    }

    public int getIdSite() {
        return this.idSite;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String getIp() {
        return this.ip;
    }

    public URL getUrlReferrer() {
        return this.urlReferrer;
    }

    public String getVisitorCustomData() {
        return this.visitorCustomData;
    }

    public void setVisitorCustomData(String visitorCustomData) {
        this.visitorCustomData = visitorCustomData;
    }
}

