/*
 * Copyright (c) 2012 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD-3-Clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
package org.pkl.thirdparty.antlr.v4.runtime.misc;

/**
 *
 * @author Sam Harwell
 */
public final class Args {

	/**
	 * @throws NullPointerException if {@code value} is {@code null}.
	 */
	public static void notNull(String parameterName, Object value) {
		if (value == null) {
			throw new NullPointerException(parameterName + " cannot be null.");
		}
	}

	private Args() {
	}

}
