/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NumberUtils;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class, receiverType=Double.class)
final class DefaultDoubleExports {
    DefaultDoubleExports() {
    }

    @ExportMessage
    static boolean fitsInByte(Double receiver) {
        double d2 = receiver;
        byte b2 = (byte)d2;
        return (double)b2 == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInInt(Double receiver) {
        double d2 = receiver;
        int i = (int)d2;
        return (double)i == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInShort(Double receiver) {
        double d2 = receiver;
        short s2 = (short)d2;
        return (double)s2 == d2 && !NumberUtils.isNegativeZero(d2);
    }

    @ExportMessage
    static boolean fitsInLong(Double receiver) {
        double d2 = receiver;
        long l = (long)d2;
        return NumberUtils.inSafeIntegerRange(d2) && !NumberUtils.isNegativeZero(d2) && (double)l == d2;
    }

    @ExportMessage
    static boolean fitsInFloat(Double receiver) {
        double d2 = receiver;
        float f = (float)d2;
        return !Double.isFinite(d2) || (double)f == d2;
    }

    @ExportMessage
    static byte asByte(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        byte b2 = (byte)d2;
        if ((double)b2 == d2 && !NumberUtils.isNegativeZero(d2)) {
            return b2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        short s2 = (short)d2;
        if ((double)s2 == d2 && !NumberUtils.isNegativeZero(d2)) {
            return s2;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static int asInt(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        int i = (int)d2;
        if ((double)i == d2 && !NumberUtils.isNegativeZero(d2)) {
            return i;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static long asLong(Double receiver) throws UnsupportedMessageException {
        long l;
        double d2 = receiver;
        if (NumberUtils.inSafeIntegerRange(d2) && !NumberUtils.isNegativeZero(d2) && (double)(l = (long)d2) == d2) {
            return l;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static float asFloat(Double receiver) throws UnsupportedMessageException {
        double d2 = receiver;
        float f = (float)d2;
        if (!Double.isFinite(d2) || (double)f == d2) {
            return f;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isNumber(Double receiver) {
        return true;
    }

    @ExportMessage
    static boolean fitsInDouble(Double receiver) {
        return true;
    }

    @ExportMessage
    static double asDouble(Double receiver) {
        return receiver;
    }

    @ExportMessage
    static boolean hasLanguage(Double receiver) {
        return false;
    }

    @ExportMessage
    static Class<? extends TruffleLanguage<?>> getLanguage(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasSourceLocation(Double receiver) {
        return false;
    }

    @ExportMessage
    static SourceSection getSourceLocation(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean hasMetaObject(Double receiver) {
        return false;
    }

    @ExportMessage
    static Object getMetaObject(Double receiver) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static Object toDisplayString(Double receiver, boolean allowSideEffects) {
        return receiver.toString();
    }
}

