/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.Nullable;

final class PCollectionToArray
implements ConverterFactory {
    PCollectionToArray() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        Class<?> targetClass = Reflection.toRawType(targetType);
        if (!sourceType.isConcreteCollectionClass() || !targetClass.isArray()) {
            return Optional.empty();
        }
        if (targetClass.getComponentType().isPrimitive()) {
            if (targetClass == boolean[].class) {
                return Optional.of(new BooleanArrayConverterImpl());
            }
            if (targetClass == char[].class) {
                return Optional.of(new CharArrayConverterImpl());
            }
            if (targetClass == long[].class) {
                return Optional.of(new LongArrayConverterImpl());
            }
            if (targetClass == int[].class) {
                return Optional.of(new IntArrayConverterImpl());
            }
            if (targetClass == short[].class) {
                return Optional.of(new ShortArrayConverterImpl());
            }
            if (targetClass == byte[].class) {
                return Optional.of(new ByteArrayConverterImpl());
            }
            if (targetClass == double[].class) {
                return Optional.of(new DoubleArrayConverterImpl());
            }
            if (targetClass == float[].class) {
                return Optional.of(new FloatArrayConverterImpl());
            }
            throw new AssertionError((Object)"unreachable code");
        }
        Type elementType = Reflection.getArrayElementType(targetType);
        return Optional.of(new ObjectArrayConverterImpl(elementType));
    }

    private static final class ObjectArrayConverterImpl<T>
    implements Converter<Collection<Object>, T[]> {
        private final Type componentType;
        private final Class<T> rawComponentType;
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, T> cachedConverter;

        private ObjectArrayConverterImpl(Type componentType) {
            this.componentType = componentType;
            Class<?> rawComponentType = Reflection.toRawType(componentType);
            this.rawComponentType = rawComponentType;
        }

        @Override
        public T[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            Object[] result = (Object[])Array.newInstance(this.rawComponentType, value2.size());
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, this.componentType);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class DoubleArrayConverterImpl
    implements Converter<Collection<Object>, double[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Double> cachedConverter;

        private DoubleArrayConverterImpl() {
        }

        @Override
        public double[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            double[] result = new double[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Double.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class FloatArrayConverterImpl
    implements Converter<Collection<Object>, float[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Float> cachedConverter;

        private FloatArrayConverterImpl() {
        }

        @Override
        public float[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            float[] result = new float[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Float.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper).floatValue();
            }
            return result;
        }
    }

    private static final class LongArrayConverterImpl
    implements Converter<Collection<Object>, long[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Long> cachedConverter;

        private LongArrayConverterImpl() {
        }

        @Override
        public long[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            long[] result = new long[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Long.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class IntArrayConverterImpl
    implements Converter<Collection<Object>, int[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Integer> cachedConverter;

        private IntArrayConverterImpl() {
        }

        @Override
        public int[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            int[] result = new int[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Integer.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class ShortArrayConverterImpl
    implements Converter<Collection<Object>, short[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Short> cachedConverter;

        private ShortArrayConverterImpl() {
        }

        @Override
        public short[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            short[] result = new short[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Short.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class ByteArrayConverterImpl
    implements Converter<Collection<Object>, byte[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Byte> cachedConverter;

        private ByteArrayConverterImpl() {
        }

        @Override
        public byte[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            byte[] result = new byte[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Byte.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }

    private static final class CharArrayConverterImpl
    implements Converter<Collection<Object>, char[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Character> cachedConverter;

        private CharArrayConverterImpl() {
        }

        @Override
        public char[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            char[] result = new char[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Character.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper).charValue();
            }
            return result;
        }
    }

    private static final class BooleanArrayConverterImpl
    implements Converter<Collection<Object>, boolean[]> {
        private PClassInfo<Object> cachedElementType = PClassInfo.Unavailable;
        private @Nullable Converter<Object, Boolean> cachedConverter;

        private BooleanArrayConverterImpl() {
        }

        @Override
        public boolean[] convert(Collection<Object> value2, ValueMapper valueMapper) {
            boolean[] result = new boolean[value2.size()];
            int i = 0;
            for (Object elem : value2) {
                if (!this.cachedElementType.isExactClassOf(elem)) {
                    this.cachedElementType = PClassInfo.forValue(elem);
                    this.cachedConverter = valueMapper.getConverter(this.cachedElementType, Boolean.TYPE);
                }
                assert (this.cachedConverter != null);
                result[i++] = this.cachedConverter.convert(elem, valueMapper);
            }
            return result;
        }
    }
}

