/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.Objects;
import org.pkl.core.DurationUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.Value;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.DurationUtils;
import org.pkl.core.util.Nullable;

public strictfp final class Duration
implements Value {
    private static final long serialVersionUID = 0L;
    private final double value;
    private final DurationUnit unit;

    public Duration(double value2, DurationUnit unit2) {
        this.value = value2;
        this.unit = Objects.requireNonNull(unit2, "unit");
    }

    public static Duration ofNanos(double value2) {
        return new Duration(value2, DurationUnit.NANOS);
    }

    public static Duration ofMicros(double value2) {
        return new Duration(value2, DurationUnit.MICROS);
    }

    public static Duration ofMillis(double value2) {
        return new Duration(value2, DurationUnit.MILLIS);
    }

    public static Duration ofSeconds(double value2) {
        return new Duration(value2, DurationUnit.SECONDS);
    }

    public static Duration ofMinutes(double value2) {
        return new Duration(value2, DurationUnit.MINUTES);
    }

    public static Duration ofHours(double value2) {
        return new Duration(value2, DurationUnit.HOURS);
    }

    public static Duration ofDays(double value2) {
        return new Duration(value2, DurationUnit.DAYS);
    }

    public double getValue() {
        return this.value;
    }

    public String toIsoString() {
        return DurationUtils.toIsoString(this.value, this.unit);
    }

    public DurationUnit getUnit() {
        return this.unit;
    }

    public double inNanos() {
        return this.convertValueTo(DurationUnit.NANOS);
    }

    public double inMicros() {
        return this.convertValueTo(DurationUnit.MICROS);
    }

    public double inMillis() {
        return this.convertValueTo(DurationUnit.MILLIS);
    }

    public double inSeconds() {
        return this.convertValueTo(DurationUnit.SECONDS);
    }

    public double inMinutes() {
        return this.convertValueTo(DurationUnit.MINUTES);
    }

    public double inHours() {
        return this.convertValueTo(DurationUnit.HOURS);
    }

    public double inDays() {
        return this.convertValueTo(DurationUnit.DAYS);
    }

    public long inWholeNanos() {
        return Math.round(this.inNanos());
    }

    public long inWholeMicros() {
        return Math.round(this.inMicros());
    }

    public long inWholeMillis() {
        return Math.round(this.inMillis());
    }

    public long inWholeSeconds() {
        return Math.round(this.inSeconds());
    }

    public long inWholeMinutes() {
        return Math.round(this.inMinutes());
    }

    public long inWholeHours() {
        return Math.round(this.inHours());
    }

    public long inWholeDays() {
        return Math.round(this.inDays());
    }

    public java.time.Duration toJavaDuration() {
        if (!Double.isFinite(this.value)) {
            throw new ArithmeticException("Cannot convert Pkl duration `" + this + "` to `java.time.Duration`.");
        }
        long l = (long)this.value;
        if ((double)l == this.value) {
            return java.time.Duration.of(l, this.unit.toChronoUnit());
        }
        double seconds = this.convertValueTo(DurationUnit.SECONDS);
        long secondsPart = (long)seconds;
        long nanosPart = (long)((seconds - (double)secondsPart) * 1.0E9);
        return java.time.Duration.ofSeconds(secondsPart, nanosPart);
    }

    public Duration convertTo(DurationUnit other) {
        return new Duration(this.convertValueTo(other), other);
    }

    public double convertValueTo(DurationUnit other) {
        return this.value * (double)this.unit.getNanos() / (double)other.getNanos();
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitDuration(this);
    }

    @Override
    public <T> T accept(ValueConverter<T> converter) {
        return converter.convertDuration(this);
    }

    @Override
    public PClassInfo<?> getClassInfo() {
        return PClassInfo.Duration;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)obj;
        return this.convertValueTo(DurationUnit.NANOS) == other.convertValueTo(DurationUnit.NANOS);
    }

    public int hashCode() {
        return Double.hashCode(this.convertValueTo(DurationUnit.NANOS));
    }

    public String toString() {
        return DurationUtils.toPklString(this.value, this.unit);
    }
}

