/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.pkl.core.Logger;
import org.pkl.core.StackFrame;

public final class Loggers {
    public static Logger noop() {
        return new Logger(){

            @Override
            public void trace(String message, StackFrame frame) {
            }

            @Override
            public void warn(String message, StackFrame frame) {
            }
        };
    }

    public static Logger stdErr() {
        return Loggers.stream(System.err);
    }

    public static Logger stream(final PrintStream stream) {
        return new Logger(){

            @Override
            public void trace(String message, StackFrame frame) {
                stream.println(Loggers.formatMessage("TRACE", message, frame));
                stream.flush();
            }

            @Override
            public void warn(String message, StackFrame frame) {
                stream.println(Loggers.formatMessage("WARN", message, frame));
                stream.flush();
            }
        };
    }

    public static Logger writer(final PrintWriter writer) {
        return new Logger(){

            @Override
            public void trace(String message, StackFrame frame) {
                writer.println(Loggers.formatMessage("TRACE", message, frame));
                writer.flush();
            }

            @Override
            public void warn(String message, StackFrame frame) {
                writer.println(Loggers.formatMessage("WARN", message, frame));
                writer.flush();
            }
        };
    }

    private static String formatMessage(String level, String message, StackFrame frame) {
        return "pkl: " + level + ": " + message + " (" + frame.getModuleUri() + ")";
    }
}

