/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import java.util.Objects;
import org.pkl.core.Release;
import org.pkl.thirdparty.graalvm.home.Version;

public final class Platform {
    private static final Platform CURRENT;
    private final Language language;
    private final Runtime runtime;
    private final VirtualMachine virtualMachine;
    private final OperatingSystem operatingSystem;
    private final Processor processor;

    public Platform(Language language, Runtime runtime, VirtualMachine virtualMachine, OperatingSystem operatingSystem, Processor processor) {
        this.language = language;
        this.runtime = runtime;
        this.virtualMachine = virtualMachine;
        this.operatingSystem = operatingSystem;
        this.processor = processor;
    }

    public static Platform current() {
        return CURRENT;
    }

    public Language language() {
        return this.language;
    }

    public Runtime runtime() {
        return this.runtime;
    }

    public VirtualMachine virtualMachine() {
        return this.virtualMachine;
    }

    public OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    public Processor processor() {
        return this.processor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Platform)) {
            return false;
        }
        Platform other = (Platform)obj;
        return this.language.equals(other.language) && this.runtime.equals(other.runtime) && this.virtualMachine.equals(other.virtualMachine) && this.operatingSystem.equals(other.operatingSystem) && this.processor.equals(other.processor);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.runtime, this.virtualMachine, this.operatingSystem, this.processor);
    }

    static {
        String pklVersion = Release.current().version().toString();
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            osName = "macOS";
        }
        String osVersion = System.getProperty("os.version");
        String architecture = System.getProperty("os.arch");
        String runtimeName = Truffle.getRuntime().getName();
        String runtimeVersion = Version.getCurrent().toString();
        String vmName = TruffleOptions.AOT ? runtimeName : System.getProperty("java.vm.name");
        String vmVersion = TruffleOptions.AOT ? runtimeVersion : System.getProperty("java.vm.version");
        CURRENT = new Platform(new Language(pklVersion), new Runtime(runtimeName, runtimeVersion), new VirtualMachine(vmName, vmVersion), new OperatingSystem(osName, osVersion), new Processor(architecture));
    }

    public static final class Processor {
        private final String architecture;

        public Processor(String architecture) {
            this.architecture = architecture;
        }

        public String architecture() {
            return this.architecture;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Processor)) {
                return false;
            }
            Processor other = (Processor)obj;
            return this.architecture.equals(other.architecture);
        }

        public int hashCode() {
            return this.architecture.hashCode();
        }
    }

    public static final class OperatingSystem {
        private final String name;
        private final String version;

        public OperatingSystem(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OperatingSystem)) {
                return false;
            }
            OperatingSystem other = (OperatingSystem)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }

    public static final class VirtualMachine {
        private final String name;
        private final String version;

        public VirtualMachine(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VirtualMachine)) {
                return false;
            }
            VirtualMachine other = (VirtualMachine)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }

    public static final class Runtime {
        private final String name;
        private final String version;

        public Runtime(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Runtime)) {
                return false;
            }
            Runtime other = (Runtime)obj;
            return this.name.equals(other.name) && this.version.equals(other.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }

    public static final class Language {
        private final String version;

        public Language(String version) {
            this.version = version;
        }

        public String version() {
            return this.version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Language)) {
                return false;
            }
            Language other = (Language)obj;
            return this.version.equals(other.version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

