/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import org.pkl.core.util.ArrayCharEscaper;

public final class ValueFormatter {
    private static final ArrayCharEscaper charEscaper = ArrayCharEscaper.builder().withEscape('\n', "\\n").withEscape('\r', "\\r").withEscape('\t', "\\t").withEscape('\"', "\\\"").withEscape('\\', "\\\\").build();
    private static final ValueFormatter BASIC = new ValueFormatter(false, false);
    private static final ValueFormatter WITH_CUSTOM_DELIMITERS = new ValueFormatter(false, true);
    private final boolean useMultilineStrings;
    private final boolean useCustomStringDelimiters;

    public static ValueFormatter basic() {
        return BASIC;
    }

    public static ValueFormatter withCustomStringDelimiters() {
        return WITH_CUSTOM_DELIMITERS;
    }

    public ValueFormatter(boolean useMultilineStrings, boolean useCustomStringDelimiters) {
        this.useMultilineStrings = useMultilineStrings;
        this.useCustomStringDelimiters = useCustomStringDelimiters;
    }

    public String formatStringValue(String value2, CharSequence lineIndent) {
        StringBuilder builder = new StringBuilder(value2.length() * 2);
        this.formatStringValue(value2, lineIndent, builder);
        return builder.toString();
    }

    public void formatStringValue(String value2, CharSequence lineIndent, StringBuilder builder) {
        try {
            this.formatStringValue(value2, lineIndent, (Appendable)builder);
        }
        catch (IOException e2) {
            throw new AssertionError((Object)"unreachable");
        }
    }

    public void formatStringValue(String value2, CharSequence lineIndent, Appendable appendable) throws IOException {
        boolean isMultiline;
        if (!this.useMultilineStrings && !this.useCustomStringDelimiters) {
            this.formatSingleLineString(value2, appendable, "");
            return;
        }
        StringFacts stringFacts = StringFacts.gather(value2);
        boolean bl = isMultiline = this.useMultilineStrings && stringFacts.isMultiline;
        if (isMultiline) {
            String poundChars = this.useCustomStringDelimiters ? "#".repeat(stringFacts.poundCharCountMultiline) : "";
            this.formatMultilineString(value2, lineIndent, appendable, poundChars);
        } else {
            String poundChars = this.useCustomStringDelimiters ? "#".repeat(stringFacts.poundCharCountSingleLine) : "";
            this.formatSingleLineString(value2, appendable, poundChars);
        }
    }

    private void formatSingleLineString(String value2, Appendable appendable, String poundChars) throws IOException {
        appendable.append(poundChars).append('\"');
        int i = 0;
        String escapeSequence = "\\" + poundChars;
        if (this.useCustomStringDelimiters) {
            if (value2.equals("\"")) {
                appendable.append(escapeSequence).append(value2);
                i = 1;
            } else if (value2.startsWith("\"\"")) {
                appendable.append('\"').append(escapeSequence).append('\"');
                i = 2;
            }
        }
        while (i < value2.length()) {
            char ch = value2.charAt(i);
            switch (ch) {
                case '\n': {
                    appendable.append(escapeSequence).append('n');
                    break;
                }
                case '\r': {
                    appendable.append(escapeSequence).append('r');
                    break;
                }
                case '\t': {
                    appendable.append(escapeSequence).append('t');
                    break;
                }
                case '\\': {
                    if (this.useCustomStringDelimiters) {
                        appendable.append(ch);
                        break;
                    }
                    appendable.append("\\\\");
                    break;
                }
                case '\"': {
                    if (this.useCustomStringDelimiters) {
                        appendable.append(ch);
                        break;
                    }
                    appendable.append("\\\"");
                    break;
                }
                default: {
                    appendable.append(ch);
                }
            }
            ++i;
        }
        appendable.append('\"').append(poundChars);
    }

    private void formatMultilineString(String value2, CharSequence lineIndent, Appendable appendable, String poundChars) throws IOException {
        int consecutiveQuotes = 0;
        String escapeSequence = "\\" + poundChars;
        appendable.append(poundChars).append("\"\"\"\n").append(lineIndent);
        block7: for (int i = 0; i < value2.length(); ++i) {
            char ch = value2.charAt(i);
            switch (ch) {
                case '\n': {
                    appendable.append('\n').append(lineIndent);
                    consecutiveQuotes = 0;
                    continue block7;
                }
                case '\r': {
                    appendable.append(escapeSequence).append('r');
                    consecutiveQuotes = 0;
                    continue block7;
                }
                case '\t': {
                    appendable.append(escapeSequence).append('t');
                    consecutiveQuotes = 0;
                    continue block7;
                }
                case '\\': {
                    if (this.useCustomStringDelimiters) {
                        appendable.append(ch);
                    } else {
                        appendable.append("\\\\");
                    }
                    consecutiveQuotes = 0;
                    continue block7;
                }
                case '\"': {
                    if (consecutiveQuotes == 2 && !this.useCustomStringDelimiters) {
                        appendable.append("\\\"");
                        consecutiveQuotes = 0;
                        continue block7;
                    }
                    appendable.append('\"');
                    ++consecutiveQuotes;
                    continue block7;
                }
                default: {
                    appendable.append(ch);
                    consecutiveQuotes = 0;
                }
            }
        }
        appendable.append("\n").append(lineIndent).append("\"\"\"").append(poundChars);
    }

    private static final class StringFacts {
        private final boolean isMultiline;
        private final int poundCharCountSingleLine;
        private final int poundCharCountMultiline;

        private StringFacts(boolean isMultiline, int poundCharCountSingleLine, int poundCharCountMultiline) {
            this.isMultiline = isMultiline;
            this.poundCharCountSingleLine = poundCharCountSingleLine;
            this.poundCharCountMultiline = poundCharCountMultiline;
        }

        static StringFacts gather(String value2) {
            boolean isMultiline = false;
            int consecutiveQuoteCount = 0;
            PoundContext currentPoundContext = PoundContext.OTHER;
            int currentPoundCountSingleQuote = 0;
            int currentPoundCountMultilineQuote = 0;
            int currentPoundCountBackslash = 0;
            int poundCountSingleQuote = 0;
            int poundCountMultilineQuote = 0;
            int poundCountBackslash = 0;
            block11: for (int i = 0; i < value2.length(); ++i) {
                char ch = value2.charAt(i);
                switch (ch) {
                    case '\\': {
                        currentPoundContext = PoundContext.BACKSLASH;
                        currentPoundCountBackslash = 1;
                        poundCountBackslash = Math.max(poundCountBackslash, currentPoundCountBackslash);
                        continue block11;
                    }
                    case '\"': {
                        if (++consecutiveQuoteCount < 3) {
                            currentPoundContext = PoundContext.SINGLELINE_QUOTE;
                            currentPoundCountSingleQuote = 1;
                            poundCountSingleQuote = Math.max(poundCountSingleQuote, currentPoundCountSingleQuote);
                            continue block11;
                        }
                        currentPoundContext = PoundContext.MULTILINE_QUOTE;
                        currentPoundCountMultilineQuote = 1;
                        poundCountMultilineQuote = Math.max(poundCountMultilineQuote, currentPoundCountMultilineQuote);
                        continue block11;
                    }
                    case '#': {
                        consecutiveQuoteCount = 0;
                        switch (currentPoundContext) {
                            case SINGLELINE_QUOTE: {
                                poundCountSingleQuote = Math.max(poundCountSingleQuote, ++currentPoundCountSingleQuote);
                                continue block11;
                            }
                            case MULTILINE_QUOTE: {
                                poundCountMultilineQuote = Math.max(poundCountMultilineQuote, ++currentPoundCountMultilineQuote);
                                continue block11;
                            }
                            case BACKSLASH: {
                                poundCountBackslash = Math.max(poundCountBackslash, ++currentPoundCountBackslash);
                                continue block11;
                            }
                        }
                        continue block11;
                    }
                    case '\n': {
                        isMultiline = true;
                    }
                    default: {
                        consecutiveQuoteCount = 0;
                        currentPoundContext = PoundContext.OTHER;
                    }
                }
            }
            return new StringFacts(isMultiline, Math.max(poundCountBackslash, poundCountSingleQuote), Math.max(poundCountBackslash, poundCountMultilineQuote));
        }

        private static enum PoundContext {
            OTHER,
            SINGLELINE_QUOTE,
            MULTILINE_QUOTE,
            BACKSLASH;

        }
    }
}

