/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.binary.EqualNode;
import org.pkl.core.runtime.VmValue;

@GeneratedBy(value=EqualNode.class)
public final class EqualNodeGen
extends EqualNode {
    @Node.Child
    private ExpressionNode leftNode_;
    @Node.Child
    private ExpressionNode rightNode_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private Eval6Data eval6_cache;

    private EqualNodeGen(SourceSection sourceSection, ExpressionNode leftNode, ExpressionNode rightNode) {
        super(sourceSection);
        this.leftNode_ = leftNode;
        this.rightNode_ = rightNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFD) == 0 && state_0 != 0) {
            return this.executeGeneric_long_long0(state_0, frameValue);
        }
        if ((state_0 & 0xFB) == 0 && state_0 != 0) {
            return this.executeGeneric_long_double1(state_0, frameValue);
        }
        if ((state_0 & 0xF7) == 0 && state_0 != 0) {
            return this.executeGeneric_double_long2(state_0, frameValue);
        }
        if ((state_0 & 0xEF) == 0 && state_0 != 0) {
            return this.executeGeneric_double_double3(state_0, frameValue);
        }
        if ((state_0 & 0xDF) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean_boolean4(state_0, frameValue);
        }
        return this.executeGeneric_generic5(state_0, frameValue);
    }

    private Object executeGeneric_long_long0(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private Object executeGeneric_long_double1(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private Object executeGeneric_double_long2(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        double leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private Object executeGeneric_double_double3(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        double leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private Object executeGeneric_boolean_boolean4(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x20) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    @ExplodeLoop
    private Object executeGeneric_generic5(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof String) {
            String leftNodeValue__ = (String)leftNodeValue_;
            if (rightNodeValue_ instanceof String) {
                String rightNodeValue__ = (String)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 6) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if ((state_0 & 2) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
            if ((state_0 & 4) != 0 && rightNodeValue_ instanceof Double) {
                double rightNodeValue__ = (Double)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x18) != 0 && leftNodeValue_ instanceof Double) {
            double leftNodeValue__ = (Double)leftNodeValue_;
            if ((state_0 & 8) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue_ instanceof Double) {
                double rightNodeValue__ = (Double)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x20) != 0 && leftNodeValue_ instanceof Boolean) {
            boolean leftNodeValue__ = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__ = (Boolean)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0xC0) != 0) {
            if ((state_0 & 0x40) != 0) {
                Eval6Data s6_ = this.eval6_cache;
                while (s6_ != null) {
                    if (leftNodeValue_.getClass() == s6_.leftJavaClass_ && rightNodeValue_.getClass() == s6_.leftJavaClass_) {
                        return this.eval(leftNodeValue_, rightNodeValue_, s6_.leftJavaClass_);
                    }
                    s6_ = s6_.next_;
                }
            }
            if ((state_0 & 0x80) != 0 && EqualNode.isIncompatibleTypes(leftNodeValue_, rightNodeValue_)) {
                return this.eval(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFD) == 0 && state_0 != 0) {
            return this.executeBoolean_long_long6(state_0, frameValue);
        }
        if ((state_0 & 0xFB) == 0 && state_0 != 0) {
            return this.executeBoolean_long_double7(state_0, frameValue);
        }
        if ((state_0 & 0xF7) == 0 && state_0 != 0) {
            return this.executeBoolean_double_long8(state_0, frameValue);
        }
        if ((state_0 & 0xEF) == 0 && state_0 != 0) {
            return this.executeBoolean_double_double9(state_0, frameValue);
        }
        if ((state_0 & 0xDF) == 0 && state_0 != 0) {
            return this.executeBoolean_boolean_boolean10(state_0, frameValue);
        }
        return this.executeBoolean_generic11(state_0, frameValue);
    }

    private boolean executeBoolean_long_long6(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_long_double7(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        long leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_long8(int state_0, VirtualFrame frameValue) {
        long rightNodeValue_;
        double leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double9(int state_0, VirtualFrame frameValue) {
        double rightNodeValue_;
        double leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean10(int state_0, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightNodeValue = this.rightNode_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x20) != 0);
        return this.eval(leftNodeValue_, rightNodeValue_);
    }

    @ExplodeLoop
    private boolean executeBoolean_generic11(int state_0, VirtualFrame frameValue) {
        Object leftNodeValue_ = this.leftNode_.executeGeneric(frameValue);
        Object rightNodeValue_ = this.rightNode_.executeGeneric(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof String) {
            String leftNodeValue__ = (String)leftNodeValue_;
            if (rightNodeValue_ instanceof String) {
                String rightNodeValue__ = (String)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 6) != 0 && leftNodeValue_ instanceof Long) {
            long leftNodeValue__ = (Long)leftNodeValue_;
            if ((state_0 & 2) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
            if ((state_0 & 4) != 0 && rightNodeValue_ instanceof Double) {
                double rightNodeValue__ = (Double)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x18) != 0 && leftNodeValue_ instanceof Double) {
            double leftNodeValue__ = (Double)leftNodeValue_;
            if ((state_0 & 8) != 0 && rightNodeValue_ instanceof Long) {
                long rightNodeValue__ = (Long)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue_ instanceof Double) {
                double rightNodeValue__ = (Double)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0x20) != 0 && leftNodeValue_ instanceof Boolean) {
            boolean leftNodeValue__ = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__ = (Boolean)rightNodeValue_;
                return this.eval(leftNodeValue__, rightNodeValue__);
            }
        }
        if ((state_0 & 0xC0) != 0) {
            if ((state_0 & 0x40) != 0) {
                Eval6Data s6_ = this.eval6_cache;
                while (s6_ != null) {
                    if (leftNodeValue_.getClass() == s6_.leftJavaClass_ && rightNodeValue_.getClass() == s6_.leftJavaClass_) {
                        return this.eval(leftNodeValue_, rightNodeValue_, s6_.leftJavaClass_);
                    }
                    s6_ = s6_.next_;
                }
            }
            if ((state_0 & 0x80) != 0 && EqualNode.isIncompatibleTypes(leftNodeValue_, rightNodeValue_)) {
                return this.eval(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            if (leftNodeValue instanceof String) {
                String leftNodeValue_ = (String)leftNodeValue;
                if (rightNodeValue instanceof String) {
                    String rightNodeValue_ = (String)rightNodeValue;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.eval(leftNodeValue_, rightNodeValue_);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Long) {
                long leftNodeValue_ = (Long)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.eval(leftNodeValue_, rightNodeValue_);
                    return bl;
                }
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_ = (Double)rightNodeValue;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.eval(leftNodeValue_, rightNodeValue_);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Double) {
                double leftNodeValue_ = (Double)leftNodeValue;
                if (rightNodeValue instanceof Long) {
                    long rightNodeValue_ = (Long)rightNodeValue;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.eval(leftNodeValue_, rightNodeValue_);
                    return bl;
                }
                if (rightNodeValue instanceof Double) {
                    double rightNodeValue_2 = (Double)rightNodeValue;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.eval(leftNodeValue_, rightNodeValue_2);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean leftNodeValue_ = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_ = (Boolean)rightNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_2 = this.eval(leftNodeValue_, rightNodeValue_);
                    return rightNodeValue_2;
                }
            }
            int count6_ = 0;
            Eval6Data s6_ = this.eval6_cache;
            if ((state_0 & 0x40) != 0) {
                while (s6_ != null && (leftNodeValue.getClass() != s6_.leftJavaClass_ || rightNodeValue.getClass() != s6_.leftJavaClass_)) {
                    s6_ = s6_.next_;
                    ++count6_;
                }
            }
            if (s6_ == null) {
                Class<? extends VmValue> leftJavaClass__ = EqualNode.getVmValueJavaClassOrNull(leftNodeValue);
                if (leftNodeValue.getClass() == leftJavaClass__ && rightNodeValue.getClass() == leftJavaClass__ && count6_ < 99) {
                    s6_ = new Eval6Data(this.eval6_cache);
                    s6_.leftJavaClass_ = leftJavaClass__;
                    VarHandle.storeStoreFence();
                    this.eval6_cache = s6_;
                    this.state_0_ = state_0 |= 0x40;
                }
            }
            if (s6_ != null) {
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(leftNodeValue, rightNodeValue, s6_.leftJavaClass_);
                return bl;
            }
            if (EqualNode.isIncompatibleTypes(leftNodeValue, rightNodeValue)) {
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                boolean bl = this.eval(leftNodeValue, rightNodeValue);
                return bl;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.leftNode_, this.rightNode_}, leftNodeValue, rightNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        Eval6Data s6_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s6_ = this.eval6_cache) == null || s6_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static EqualNode create(SourceSection sourceSection, ExpressionNode leftNode, ExpressionNode rightNode) {
        return new EqualNodeGen(sourceSection, leftNode, rightNode);
    }

    @GeneratedBy(value=EqualNode.class)
    private static final class Eval6Data {
        @CompilerDirectives.CompilationFinal
        Eval6Data next_;
        @CompilerDirectives.CompilationFinal
        Class<? extends VmValue> leftJavaClass_;

        Eval6Data(Eval6Data next_) {
            this.next_ = next_;
        }
    }
}

