/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.util.Nullable;

@NodeInfo(shortName="!=")
@NodeChildren(value={@NodeChild(value="leftNode", type=ExpressionNode.class), @NodeChild(value="rightNode", type=ExpressionNode.class)})
public abstract class NotEqualNode
extends ExpressionNode {
    protected NotEqualNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    protected boolean eval(String left, String right) {
        return !left.equals(right);
    }

    @Specialization
    protected boolean eval(long left, long right) {
        return left != right;
    }

    @Specialization
    protected boolean eval(long left, double right) {
        return (double)left != right;
    }

    @Specialization
    protected boolean eval(double left, long right) {
        return left != (double)right;
    }

    @Specialization
    protected boolean eval(double left, double right) {
        return left != right;
    }

    @Specialization
    protected boolean eval(boolean left, boolean right) {
        return left != right;
    }

    @Specialization(guards={"left.getClass() == leftJavaClass", "right.getClass() == leftJavaClass"}, limit="99")
    protected boolean eval(Object left, Object right, @Cached(value="getVmValueJavaClassOrNull(left)") Class<? extends VmValue> leftJavaClass) {
        return !this.equals(left, right);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean equals(Object left, Object right) {
        return left.equals(right);
    }

    protected static @Nullable Class<? extends VmValue> getVmValueJavaClassOrNull(Object value2) {
        return value2 instanceof VmValue ? ((VmValue)value2).getClass() : null;
    }

    @Specialization(guards={"isIncompatibleTypes(left, right)"})
    protected boolean eval(Object left, Object right) {
        return true;
    }

    protected static boolean isIncompatibleTypes(Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        return leftClass == Long.class || leftClass == Double.class ? rightClass != Long.class && rightClass != Double.class : leftClass != rightClass;
    }
}

