/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.runtime.BaseModule;

public final class GeneratorWhenNode
extends GeneratorMemberNode {
    @Node.Child
    private ExpressionNode conditionNode;
    @Node.Children
    private final GeneratorMemberNode[] thenNodes;
    @Node.Children
    private final GeneratorMemberNode[] elseNodes;

    public GeneratorWhenNode(SourceSection sourceSection, ExpressionNode conditionNode, GeneratorMemberNode[] thenNodes, GeneratorMemberNode[] elseNodes) {
        super(sourceSection);
        this.conditionNode = conditionNode;
        this.thenNodes = thenNodes;
        this.elseNodes = elseNodes;
    }

    @Override
    @ExplodeLoop
    public void execute(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data) {
        boolean condition;
        try {
            condition = this.conditionNode.executeBoolean(frame);
        }
        catch (UnexpectedResultException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().typeMismatch(e2.getResult(), BaseModule.getBooleanClass()).withSourceSection(this.conditionNode.getSourceSection()).build();
        }
        for (GeneratorMemberNode node : condition ? this.thenNodes : this.elseNodes) {
            node.execute(frame, parent, data);
        }
    }
}

