/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.ElementsEntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;

@ImportStatic(value={BaseModule.class})
public abstract class ElementsEntriesLiteralNode
extends SpecializedObjectLiteralNode {
    private final ObjectMember[] elements;
    @Node.Children
    private final ExpressionNode[] keyNodes;
    private final ObjectMember[] values;

    public ElementsEntriesLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> properties, ObjectMember[] elements, ExpressionNode[] keyNodes, ObjectMember[] values2) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, properties);
        this.elements = elements;
        this.keyNodes = keyNodes;
        this.values = values2;
        assert (elements.length > 0);
    }

    @Override
    protected ElementsEntriesLiteralNode copy(ExpressionNode newParentNode) {
        return ElementsEntriesLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, this.elements, this.keyNodes, this.values, newParentNode);
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected VmListing evalListing(VirtualFrame frame, VmListing parent) {
        return new VmListing(frame.materialize(), (VmObject)parent, this.createMembers(frame, parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected VmDynamic evalDynamic(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, this.createMembers(frame, parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)") AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingAmendment()"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent) {
        return new VmListing(frame.materialize(), (VmObject)BaseModule.getListingClass().getPrototype(), this.createMembers(frame, 0), this.elements.length);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), this.createMembers(frame, 0), this.elements.length);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        this.elementsEntriesFallback(parent, this.elements[0], true);
    }

    @ExplodeLoop
    protected UnmodifiableEconomicMap<Object, ObjectMember> createMembers(VirtualFrame frame, int parentLength) {
        EconomicMap<Object, ObjectMember> result = EconomicMaps.create(EconomicMaps.size(this.members) + this.keyNodes.length + this.elements.length);
        EconomicMaps.putAll(result, this.members);
        this.addListEntries(frame, parentLength, result, this.keyNodes, this.values);
        for (int i = 0; i < this.elements.length; ++i) {
            EconomicMaps.put(result, Long.valueOf(parentLength + i), this.elements[i]);
        }
        return result;
    }
}

