/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.ObjectLiteralNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;

public abstract class SpecializedObjectLiteralNode
extends ObjectLiteralNode {
    protected final UnmodifiableEconomicMap<Object, ObjectMember> members;
    @CompilerDirectives.CompilationFinal
    protected long maxListingMemberIndex = Long.MIN_VALUE;
    @CompilerDirectives.CompilationFinal
    private boolean checkedIsValidMappingAmendment;

    public SpecializedObjectLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> members) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes);
        this.members = members;
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean checkIsValidTypedAmendment(Object parent) {
        VmClass parentClass = parent instanceof VmClass ? (VmClass)parent : VmUtils.getClass(parent);
        VmUtils.checkIsInstantiable(parentClass, this.getParentNode());
        for (ObjectMember member : EconomicMaps.getValues(this.members)) {
            String errMsg;
            if (member.isLocal()) continue;
            Identifier memberName = member.getName();
            if (!parentClass.hasProperty(memberName)) {
                throw this.exceptionBuilder().cannotFindProperty(parentClass.getPrototype(), memberName, false, false).withSourceSection(member.getHeaderSection()).build();
            }
            ClassProperty classProperty = parentClass.getProperty(memberName);
            if (classProperty == null || !classProperty.isConstOrFixed()) continue;
            boolean isAmendsDeclaration = member.getHeaderSection().getCharIndex() == member.getBodySection().getCharIndex();
            String string = errMsg = isAmendsDeclaration ? "cannotAmendFixedProperty" : "cannotAssignFixedProperty";
            if (classProperty.isConst()) {
                errMsg = isAmendsDeclaration ? "cannotAmendConstProperty" : "cannotAssignConstProperty";
            }
            throw this.exceptionBuilder().evalError(errMsg, memberName).withSourceSection(member.getHeaderSection()).build();
        }
        if (this.parametersDescriptor != null) {
            throw this.exceptionBuilder().evalError("objectAmendmentCannotHaveParameters", new Object[0]).withLocation(this.getParentNode()).build();
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected final boolean checkIsValidListingAmendment() {
        if (this.maxListingMemberIndex != Long.MIN_VALUE) {
            return true;
        }
        UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(this.members);
        long maxIndex = -1L;
        while (cursor.advance()) {
            ObjectMember member = cursor.getValue();
            if (member.isLocal()) continue;
            Identifier memberName = member.getNameOrNull();
            if (memberName == null) {
                Object key2 = cursor.getKey();
                if (!(key2 instanceof Long)) {
                    CompilerDirectives.transferToInterpreter();
                    throw this.exceptionBuilder().evalError("wrongListingKeyType", new VmException.ProgramValue("", VmUtils.getClass(key2))).withSourceSection(member.getHeaderSection()).build();
                }
                long index = (Long)key2;
                if (index < 0L) {
                    maxIndex = Long.MAX_VALUE;
                    break;
                }
                if (index <= maxIndex) continue;
                maxIndex = index;
                continue;
            }
            if (memberName == Identifier.DEFAULT) continue;
            throw this.exceptionBuilder().evalError("objectCannotHaveProperty", BaseModule.getListingClass()).withSourceSection(member.getHeaderSection()).build();
        }
        if (this.parametersDescriptor != null) {
            throw this.exceptionBuilder().evalError("listingAmendmentCannotHaveParameters", new Object[0]).withSourceSection(this.getParentNode().getSourceSection()).build();
        }
        this.maxListingMemberIndex = maxIndex;
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected final boolean checkIsValidMappingAmendment() {
        if (this.checkedIsValidMappingAmendment) {
            return true;
        }
        for (ObjectMember member : EconomicMaps.getValues(this.members)) {
            Identifier memberName;
            if (member.isLocal() || (memberName = member.getNameOrNull()) == null || memberName == Identifier.DEFAULT) continue;
            throw this.exceptionBuilder().evalError("objectCannotHaveProperty", BaseModule.getMappingClass()).withSourceSection(member.getHeaderSection()).build();
        }
        if (this.parametersDescriptor != null) {
            throw this.exceptionBuilder().evalError("mappingAmendmentCannotHaveParameters", new Object[0]).withSourceSection(this.getParentNode().getSourceSection()).build();
        }
        this.checkedIsValidMappingAmendment = true;
        return true;
    }

    protected final boolean checkMaxListingMemberIndex(int parentLength) {
        assert (this.maxListingMemberIndex != Long.MIN_VALUE);
        if (this.maxListingMemberIndex < (long)parentLength) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(this.members);
        while (cursor.advance()) {
            long index;
            Object key2 = cursor.getKey();
            if (!(key2 instanceof Long) || (index = ((Long)key2).longValue()) >= 0L && index < (long)parentLength) continue;
            throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, parentLength - 1).withSourceSection(cursor.getValue().getHeaderSection()).build();
        }
        throw this.exceptionBuilder().unreachableCode().build();
    }

    @ExplodeLoop
    protected void addListEntries(VirtualFrame frame, int parentLength, EconomicMap<Object, ObjectMember> result, ExpressionNode[] keyNodes, ObjectMember[] values2) {
        for (int i = 0; i < keyNodes.length; ++i) {
            long index;
            try {
                index = keyNodes[i].executeInt(frame);
            }
            catch (UnexpectedResultException e2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("wrongListingKeyType", new VmException.ProgramValue("", VmUtils.getClass(e2.getResult()))).withSourceSection(keyNodes[i].getSourceSection()).build();
            }
            ObjectMember value2 = values2[i];
            if (index < 0L || index >= (long)parentLength) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, parentLength - 1).withSourceSection(value2.getHeaderSection()).build();
            }
            if (EconomicMaps.put(result, index, value2) == null) continue;
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("duplicateDefinition", new VmException.ProgramValue("", index)).withSourceSection(value2.getHeaderSection()).build();
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected @Nullable ObjectMember findFirstNonProperty(UnmodifiableEconomicMap<Object, ObjectMember> members) {
        UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(members);
        while (cursor.advance()) {
            ObjectMember member = cursor.getValue();
            if (member.getNameOrNull() != null) continue;
            return member;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    protected @Nullable ObjectMember findFirstNonDefaultProperty(UnmodifiableEconomicMap<Object, ObjectMember> members) {
        UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(members);
        while (cursor.advance()) {
            ObjectMember member = cursor.getValue();
            if (member.getNameOrNull() == null || member.getNameOrNull() == Identifier.DEFAULT) continue;
            return member;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    protected void elementsEntriesFallback(Object parent, @Nullable ObjectMember firstElemOrEntry, boolean isElementsOnly) {
        boolean parentIsClass = parent instanceof VmClass;
        VmClass parentClass = parentIsClass ? (VmClass)parent : VmUtils.getClass(parent);
        VmUtils.checkIsInstantiable(parentClass, this.getParentNode());
        ObjectMember property = this.findFirstNonDefaultProperty(this.members);
        if (property != null && (parentClass == BaseModule.getListingClass() || parentClass == BaseModule.getMappingClass())) {
            throw this.exceptionBuilder().evalError("objectCannotHaveProperty", parentClass).withSourceSection(property.getHeaderSection()).build();
        }
        assert (firstElemOrEntry != null);
        if (SpecializedObjectLiteralNode.isTypedObjectClass(parentClass) || isElementsOnly && parentClass == BaseModule.getMappingClass()) {
            throw this.exceptionBuilder().evalError(isElementsOnly ? "objectCannotHaveElement" : "objectCannotHaveEntry", parentClass).withSourceSection(firstElemOrEntry.getHeaderSection()).build();
        }
        throw this.exceptionBuilder().unreachableCode().build();
    }
}

